/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.corereports.charts.report;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.ChartFactory;
import com.atlassian.jira.charts.jfreechart.TimePeriodUtils;
import com.atlassian.jira.charts.report.AbstractChartReport;
import com.atlassian.jira.charts.util.ChartUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ResolutionTimeReport
extends AbstractChartReport {
    private final ChartFactory chartFactory;
    private final TimeZoneManager timeZoneManager;

    @Inject
    public ResolutionTimeReport(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport ProjectManager projectManager, @ComponentImport SearchRequestService searchRequestService, @ComponentImport ChartUtils chartUtils, @ComponentImport ChartFactory chartFactory, @ComponentImport TimeZoneManager timeZoneManager) {
        super(authenticationContext, applicationProperties, projectManager, searchRequestService, chartUtils);
        this.chartFactory = chartFactory;
        this.timeZoneManager = timeZoneManager;
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("report", (Object)this);
        params.put("action", action);
        params.put("user", this.authenticationContext.getUser());
        params.put("timePeriods", new TimePeriodUtils(this.timeZoneManager));
        String projectOrFilterId = (String)reqParams.get("projectOrFilterId");
        ChartFactory.PeriodName periodName = ChartFactory.PeriodName.valueOf((String)((String)reqParams.get("periodName")));
        int days = 30;
        if (reqParams.containsKey("daysprevious")) {
            days = Integer.parseInt((String)reqParams.get("daysprevious"));
        }
        SearchRequest request = this.chartUtils.retrieveOrMakeSearchRequest(projectOrFilterId, params);
        params.put("projectOrFilterId", projectOrFilterId);
        ChartFactory.ChartContext context = new ChartFactory.ChartContext(this.authenticationContext.getUser(), request, 800, 500, true);
        Chart chart = this.chartFactory.generateDateRangeTimeChart(context, days, periodName, DateUtils.DAY_MILLIS, "datacollector.daystoresolve", "resolutiondate");
        params.putAll(chart.getParameters());
        return this.descriptor.getHtml("view", params);
    }
}

