/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.user;

import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.session.GenerateTokenResult;
import com.atlassian.hipchat.api.users.InviteUserResult;
import com.atlassian.hipchat.api.users.User;
import com.atlassian.plugins.hipchat.user.HipChatUserManager;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

@Internal
public class DefaultHipChatUserManager
implements HipChatUserManager {
    private final HipChatScope[] PASSWORD_GENERATION_SCOPES = new HipChatScope[]{HipChatScope.ViewGroup, HipChatScope.SendMessage, HipChatScope.SendNotification};

    @Override
    public Result<HipChatUserManager.HipChatUserConfiguration> createNewSystemUser(HipChatAPI<HipChatAPI.TokenType.AddonToken> api) {
        try {
            String username = this.createUniqueUsername();
            String password = UUID.randomUUID().toString();
            Result userResult = (Result)api.users().createUser("confluence system", "confluence", null, false, "UTC", password, username).get();
            if (userResult.isError()) {
                return userResult.asError();
            }
            Result userToken = (Result)api.sessions().generatePasswordToken(username, password, this.PASSWORD_GENERATION_SCOPES).get();
            if (userToken.isError()) {
                this.deleteUserAccount(api, username);
                return userToken.asError();
            }
            Result userDetails = (Result)api.users().getUser(username).get();
            if (userDetails.isError()) {
                this.deleteUserAccount(api, username);
                return userDetails.asError();
            }
            return Result.success(new HipChatUserManager.HipChatUserConfiguration(username, password, ((GenerateTokenResult)userToken.success()).getAccessToken(), ((User)userDetails.success()).getGroup().getName(), ((GenerateTokenResult)userToken.success()).getExpiresIn()));
        }
        catch (Exception ex) {
            return Result.error(ex);
        }
    }

    @Override
    public Result<Void> deleteUserAccount(HipChatAPI<HipChatAPI.TokenType.AddonToken> api, String usernameOrId) throws ExecutionException, InterruptedException {
        Result result = (Result)api.users().deleteUser(usernameOrId).get();
        if (result.isError()) {
            return result.asError();
        }
        return result;
    }

    @Override
    public Result<InviteUserResult> inviteUserToHipchat(HipChatAPI<?> api, String name, String email, Option<String> title) {
        try {
            return (Result)api.users().inviteUser(email, name, title).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return Result.error(e);
        }
    }

    private String createUniqueUsername() {
        return "confluence." + UUID.randomUUID().toString().replace("-", "") + "@example.com";
    }
}

