/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.group;

import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.users.AllUsersResult;
import com.atlassian.hipchat.api.users.CollapsedUser;
import com.atlassian.hipchat.api.users.ExpandedUser;
import com.atlassian.hipchat.api.users.User;
import com.atlassian.hipchat.api.users.UserService;
import com.atlassian.plugins.hipchat.group.HipChatGroupProvider;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHipChatGroupProvider
implements HipChatGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatGroupProvider.class);

    @Override
    public Promise<Result<User.Group>> getCurrentGroup(UserService userService) {
        Promise<Result<AllUsersResult>> usersPromise = userService.getAllUsers().startIndex(0).maxResults(1).includeDeleted(false).includeGuests(false).expand("items").build();
        try {
            return usersPromise.map((Function)new Function<Result<AllUsersResult>, Result<User.Group>>(){

                public Result<User.Group> apply(@Nonnull Result<AllUsersResult> inputResult) {
                    if (inputResult.isError()) {
                        logger.warn("Error result returned when fetching list of users.");
                        return inputResult.asError();
                    }
                    List<CollapsedUser> users = inputResult.success().getUsers();
                    if (CollectionUtils.isEmpty(users)) {
                        return Result.error("Empty list of users returned.");
                    }
                    ExpandedUser user = (ExpandedUser)users.get(0).expanded();
                    return Result.success(user.getGroup());
                }
            });
        }
        catch (Exception e) {
            logger.error("Encountered error while waiting for list of users.", (Throwable)e);
            return this.errorResultPromise(e);
        }
    }

    private Promise<Result<User.Group>> errorResultPromise(Throwable e) {
        return Promises.promise(Result.error(e));
    }
}

