/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.user;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.json.JsonableJacksonService;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.plugins.hipchat.descriptor.HipChatScopesManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import java.net.URI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatUserLinkContextDataProvider
implements WebResourceDataProvider {
    private static final Logger log = LoggerFactory.getLogger(HipChatUserLinkContextDataProvider.class);
    private final JsonableJacksonService jsonableJacksonService;
    private final HipChatRoutesProvider routesProvider;
    private final UserManager userManager;
    private final HipChatUserFinder hipChatUserFinder;
    private final HipChatScopesManager scopesManager;

    public HipChatUserLinkContextDataProvider(JsonableJacksonService jsonableJacksonService, HipChatRoutesProvider routesProvider, UserManager userManager, HipChatUserFinder hipChatUserFinder, HipChatScopesManager scopesManager) {
        this.jsonableJacksonService = jsonableJacksonService;
        this.routesProvider = routesProvider;
        this.userManager = userManager;
        this.hipChatUserFinder = hipChatUserFinder;
        this.scopesManager = scopesManager;
    }

    public Jsonable get() {
        boolean hasManageRoomsScope = this.scopesManager.getLastSynchronisedScopes().contains((Object)HipChatScope.ManageRooms);
        HashMap<String, Comparable<URI>> userLinkData = new HashMap<String, Comparable<URI>>();
        userLinkData.put("beginOauth", this.routesProvider.getBeginOauth2Uri());
        userLinkData.put("userLinked", Boolean.valueOf(this.isUserLinked()));
        userLinkData.put("userHasManageRoomsScope", Boolean.valueOf(hasManageRoomsScope));
        return this.jsonableJacksonService.toJsonable(userLinkData);
    }

    private boolean isUserLinked() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            return false;
        }
        Option<HipChatUserId> hipChatUser = this.hipChatUserFinder.findHipChatUserIdWithPersonalToken(user.getUserKey());
        return hipChatUser.isDefined();
    }
}

