/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.notification;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.MessageFormat;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import javax.annotation.Nonnull;

@ExperimentalApi
public class DefaultHipChatNotificationOptions
implements HipChatNotificationOptions {
    private final MessageFormat messageFormat;
    private final Option<MessageBgColor> backgroundColor;
    private final boolean notifyingClients;
    private final Option<Card> card;
    private final Option<String> attachTo;

    private DefaultHipChatNotificationOptions(@Nonnull MessageFormat messageFormat, @Nonnull Option<MessageBgColor> backgroundColor, boolean notifyingClients, @Nonnull Option<Card> card, @Nonnull Option<String> attachTo) {
        this.messageFormat = messageFormat;
        this.backgroundColor = backgroundColor;
        this.notifyingClients = notifyingClients;
        this.card = card;
        this.attachTo = attachTo;
    }

    @Override
    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    public Option<MessageBgColor> getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public boolean isNotifyingClients() {
        return this.notifyingClients;
    }

    @Override
    public Option<String> getAttachTo() {
        return this.attachTo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultHipChatNotificationOptions that = (DefaultHipChatNotificationOptions)o;
        if (this.notifyingClients != that.notifyingClients) {
            return false;
        }
        if (!this.backgroundColor.equals(that.backgroundColor)) {
            return false;
        }
        if (this.messageFormat != that.messageFormat) {
            return false;
        }
        return this.attachTo.equals(that.attachTo);
    }

    public int hashCode() {
        int result = this.messageFormat.hashCode();
        result = 31 * result + this.backgroundColor.hashCode();
        result = 31 * result + (this.notifyingClients ? 1 : 0);
        return result;
    }

    @Override
    public Option<Card> getCard() {
        return this.card;
    }

    public static class DefaultHipChatNotificationOptionsBuilder {
        private MessageFormat messageFormat = MessageFormat.HTML;
        private Option<MessageBgColor> backgroundColor = Option.none();
        private boolean notifyingClients = false;
        private Option<Card> card = Option.none();
        private Option<String> attachTo = Option.none();

        public DefaultHipChatNotificationOptionsBuilder setMessageFormat(MessageFormat messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        public DefaultHipChatNotificationOptionsBuilder setBackgroundColor(Option<MessageBgColor> backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public DefaultHipChatNotificationOptionsBuilder setNotifyingClients(boolean notifyingClients) {
            this.notifyingClients = notifyingClients;
            return this;
        }

        public DefaultHipChatNotificationOptionsBuilder setCard(Option<Card> card) {
            this.card = card;
            return this;
        }

        public DefaultHipChatNotificationOptionsBuilder setAttachTo(Option<String> attachTo) {
            this.attachTo = attachTo;
            return this;
        }

        public DefaultHipChatNotificationOptions build() {
            return new DefaultHipChatNotificationOptions(this.messageFormat, this.backgroundColor, this.notifyingClients, this.card != null ? this.card : Option.none(), this.attachTo);
        }
    }
}

