/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.glances;

import java.net.URL;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class GlanceData {
    private final Label label;
    private final Status status;
    private final Object metadata;

    private static void checkLength(String name, String value, int maxLength) {
        if (value != null && value.length() > maxLength) {
            throw new IllegalArgumentException("length of " + name + " '" + value + "' must be <= " + maxLength);
        }
    }

    @JsonCreator
    public GlanceData(Label label, Status status) {
        this(label, status, null);
    }

    @JsonCreator
    public GlanceData(Label label, Status status, Object metadata) {
        this.label = label;
        this.status = status;
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlanceData that = (GlanceData)o;
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    @JsonProperty
    public Label getLabel() {
        return this.label;
    }

    @JsonProperty
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty
    public Object getMetadata() {
        return this.metadata;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Status {
        private final Type type;
        private final Value value;

        @JsonCreator
        public Status(Type type, Value value) {
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public Value getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            if (this.type != status.type) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(status.value) : status.value != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public static class IconValue
        extends Value {
            private final URL url;

            @JsonCreator
            public IconValue(URL url) {
                this.url = url;
            }

            @JsonProperty
            public URL getUrl() {
                return this.url;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                IconValue iconValue = (IconValue)o;
                return !(this.url != null ? !this.url.equals(iconValue.url) : iconValue.url != null);
            }

            public int hashCode() {
                return this.url != null ? this.url.hashCode() : 0;
            }
        }

        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public static class LozengeValue
        extends Value {
            private final String label;
            private final Type type;

            @JsonCreator
            public LozengeValue(String label, Type type) {
                GlanceData.checkLength("label", label, 20);
                this.label = label;
                this.type = type;
            }

            @JsonProperty
            public String getLabel() {
                return this.label;
            }

            @JsonProperty
            public Type getType() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LozengeValue that = (LozengeValue)o;
                if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
                    return false;
                }
                return this.type == that.type;
            }

            public int hashCode() {
                int result = this.label != null ? this.label.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }

            public static enum Type {
                DEFAULT("default"),
                SUCCESS("success"),
                ERROR("error"),
                CURRENT("current"),
                NEW("new"),
                COMPLETE("complete"),
                MOVED("moved");

                private final String jsonString;

                private Type(String jsonString) {
                    this.jsonString = jsonString;
                }

                @JsonValue
                public String getJsonString() {
                    return this.jsonString;
                }
            }
        }

        public static class Value {
        }

        public static enum Type {
            lozenge,
            icon;

        }
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Label {
        private final Type type;
        private final String value;

        @JsonCreator
        public Label(Type type, String value) {
            GlanceData.checkLength("value", value, 1000);
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        @JsonProperty
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Label label = (Label)o;
            if (this.type != label.type) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(label.value) : label.value != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public static enum Type {
            html;

        }
    }
}

