/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.emoticons;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.emoticons.EmoticonService;
import com.atlassian.hipchat.api.emoticons.EmoticonType;
import com.atlassian.hipchat.api.emoticons.GetAllEmoticonsResult;
import com.atlassian.hipchat.api.emoticons.GetEmoticonResult;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.sun.jersey.api.client.Client;
import java.net.URI;

public class DefaultEmoticonService<T extends HipChatAPI.TokenType>
implements EmoticonService {
    private final Client client;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultEmoticonService(Client client, HipChatRoutesProvider.Routes<T> routes, ClientResponseMapper mapper) {
        this.client = client;
        this.routes = routes;
        this.mapper = mapper;
    }

    @Override
    public Promise<Result.CacheableResult<GetAllEmoticonsResult>> getAllEmoticons(Option<Integer> startIndex, Option<Integer> maxResults, Option<EmoticonType> type, Option<String> etag) {
        return this.routes.getAllEmoticons(startIndex, maxResults, type).flatMap(ResourceMapper.toConditionalGetAsyncJsonResource(this.client, etag)).map(this.mapper.conditionalTo(GetAllEmoticonsResult.class)).recover((Function)new Function<Throwable, Result.CacheableResult<GetAllEmoticonsResult>>(){

            public Result.CacheableResult<GetAllEmoticonsResult> apply(Throwable input) {
                return Result.CacheableResult.fromResult(Result.error(input));
            }
        });
    }

    @Override
    public Promise<Result.CacheableResult<GetEmoticonResult>> getEmoticon(Either<Integer, String> idOrShortcut) {
        Promise<URI> uri = idOrShortcut.isLeft() ? this.routes.getEmoticonById((Integer)idOrShortcut.left().get()) : this.routes.getEmoticonByShortcut((String)idOrShortcut.right().get());
        return uri.flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.conditionalTo(GetEmoticonResult.class)).recover((Function)new Function<Throwable, Result.CacheableResult<GetEmoticonResult>>(){

            public Result.CacheableResult<GetEmoticonResult> apply(Throwable input) {
                return Result.CacheableResult.fromResult(Result.error(input));
            }
        });
    }
}

