/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatToken;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.hipchat.api.connect.DataURIGenerator;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptor;
import com.atlassian.hipchat.api.emoticons.EmoticonType;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class DefaultHipChatRoutesProvider
implements HipChatRoutesProvider {
    private final DataURIGenerator dataURIGenerator;

    public DefaultHipChatRoutesProvider(DataURIGenerator dataURIGenerator) {
        this.dataURIGenerator = dataURIGenerator;
    }

    @Override
    public <T extends HipChatAPI.TokenType> HipChatRoutesProvider.Routes<T> routes(final String api, final HipChatTokenReference authToken) {
        return new HipChatRoutesProvider.Routes<T>(){

            @Override
            public URI install(ConnectDescriptor descriptor) {
                return UriBuilder.fromPath((String)api).path("addons/install").queryParam("url", new Object[]{DefaultHipChatRoutesProvider.this.dataURIGenerator.generateDataUri(descriptor)}).queryParam("signup", new Object[]{"0"}).build(new Object[0]);
            }

            @Override
            public URI uninstall(String hipchatAddOnKey, String oAuthId) {
                return UriBuilder.fromPath((String)api).path("addons/uninstall").queryParam("key", new Object[]{hipchatAddOnKey}).queryParam("oauth_id", new Object[]{oAuthId}).build(new Object[0]);
            }

            @Override
            public Promise<URI> createUser() {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/user", new Object[0]));
            }

            @Override
            public URI authorize(URI callback, String oAuthID, String xsrfToken, String scopes) {
                return UriBuilder.fromPath((String)api).path("users/authorize").queryParam("redirect_uri", new Object[]{callback}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{scopes}).queryParam("client_id", new Object[]{oAuthID}).queryParam("state", new Object[]{xsrfToken}).build(new Object[0]);
            }

            @Override
            public URI generateToken() {
                return UriBuilder.fromPath((String)api).path("v2/oauth/token").build(new Object[0]);
            }

            @Override
            public Promise<URI> getSession(String sessionId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/oauth/token/{sessionId}", sessionId));
            }

            @Override
            public Promise<URI> deleteSession(String sessionId) {
                return this.getSession(sessionId);
            }

            @Override
            public Promise<URI> getHealthCheck() {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/health-check", new Object[0]));
            }

            @Override
            public Promise<URI> getUser(String usernameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/user/{username}", usernameOrId));
            }

            @Override
            public Promise<URI> getAllUsers(Option<Integer> startIndex, Option<Integer> maxResults, Option<Boolean> includeGuests, Option<Boolean> includeDeleted, Option<String> expansions) {
                ImmutableMap parameters = ImmutableMap.builder().put((Object)"start-index", startIndex).put((Object)"max-results", maxResults).put((Object)"include-guests", includeGuests).put((Object)"include-deleted", includeDeleted).put((Object)"expand", expansions).build();
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "v2/user", (Map<String, Option<?>>)parameters, new Object[0]));
            }

            @Override
            public Promise<URI> deleteUser(String usernameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/user/{username}", usernameOrId));
            }

            @Override
            public Promise<URI> getGroup(String groupId, Option<String> expansions) {
                ImmutableMap parameters = ImmutableMap.builder().put((Object)"expand", expansions).build();
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "v2/group/{groupId}", (Map<String, Option<?>>)parameters, groupId));
            }

            @Override
            public Promise<URI> getGroupStatistics(String groupId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/group/{groupId}/statistics", groupId));
            }

            @Override
            public Promise<URI> sendPrivateMessage(String usernameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "v2/user/{username}/message", usernameOrId));
            }

            @Override
            public URI getCapabilities() {
                return UriBuilder.fromPath((String)api).path("v2/capabilities").build(new Object[0]);
            }

            @Override
            public URI getFeatures() {
                return UriBuilder.fromPath((String)api).path("api/features").build(new Object[0]);
            }

            private Function<HipChatToken, URI> buildURI(final String apiUrl, final String path, final Object ... parameters) {
                return new Function<HipChatToken, URI>(){

                    public URI apply(HipChatToken authToken) {
                        return UriBuilder.fromPath((String)apiUrl).path(path).queryParam("auth_token", new Object[]{authToken.getToken()}).build(parameters);
                    }
                };
            }

            private Function<HipChatToken, URI> buildURIWithQueryParams(final String apiUrl, final String path, final Map<String, Option<?>> queryParams, final Object ... parameters) {
                return new Function<HipChatToken, URI>(){

                    public URI apply(HipChatToken authToken) {
                        UriBuilder builder = UriBuilder.fromPath((String)apiUrl).path(path).queryParam("auth_token", new Object[]{authToken.getToken()});
                        for (Map.Entry entry : queryParams.entrySet()) {
                            if (!((Option)entry.getValue()).isDefined()) continue;
                            builder.queryParam((String)entry.getKey(), new Object[]{((Option)entry.getValue()).get()});
                        }
                        return builder.build(parameters);
                    }
                };
            }

            @Override
            public HipChatTokenReference getToken() {
                return authToken;
            }

            @Override
            public Promise<URI> viewRecentPrivateChatHistory(String username, Option<Integer> maxResults, Option<String> timezone, Option<String> notBefore) {
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "/v2/user/{id_or_email}/history/latest", (Map<String, Option<?>>)ImmutableMap.of((Object)"max-results", maxResults, (Object)"timezone", timezone, (Object)"not-before", notBefore), username));
            }

            @Override
            public Promise<URI> viewRecentRoomHistory(String roomNameOrId, Option<Integer> maxResults, Option<String> timezone, Option<String> notBefore) {
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "/v2/room/{id_or_name}/history/latest", (Map<String, Option<?>>)ImmutableMap.of((Object)"max-results", maxResults, (Object)"timezone", timezone, (Object)"not-before", notBefore), roomNameOrId));
            }

            @Override
            public Promise<URI> getAllEmoticons(Option<Integer> startIndex, Option<Integer> maxResults, Option<EmoticonType> type) {
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "/v2/emoticon", (Map<String, Option<?>>)ImmutableMap.of((Object)"start-index", startIndex, (Object)"max-results", maxResults, (Object)"type", type), new Object[0]));
            }

            @Override
            public Promise<URI> getEmoticonById(Integer id) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/emoticon/{id}", id));
            }

            @Override
            public Promise<URI> getEmoticonByShortcut(String shortcut) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/emoticon/{shortcut}", shortcut));
            }

            @Override
            public Promise<URI> getAllRooms(Option<Integer> startIndex, Option<Integer> maxResults, Option<Boolean> includeArchived, Option<Boolean> includePrivate, Option<String> expansions) {
                ImmutableMap parameters = ImmutableMap.builder().put((Object)"start-index", startIndex).put((Object)"max-results", maxResults).put((Object)"include-archived", includeArchived).put((Object)"include-private", includePrivate).put((Object)"expand", expansions).build();
                return ((Promise)authToken.get()).map(this.buildURIWithQueryParams(api, "/v2/room", (Map<String, Option<?>>)parameters, new Object[0]));
            }

            @Override
            public Promise<URI> getRoom(String roomId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id}", roomId));
            }

            @Override
            public Promise<URI> getRoomMessage(String roomNameOrId, String messageId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}/history/{message_id}", roomNameOrId, messageId));
            }

            @Override
            public Promise<URI> sendRoomMessage(String roomNameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}/notification", roomNameOrId));
            }

            @Override
            public Promise<URI> createRoom() {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room", new Object[0]));
            }

            @Override
            public Promise<URI> deleteRoom(String roomNameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}", roomNameOrId));
            }

            @Override
            public Promise<URI> getRoomGlance(String roomNameOrId, String glanceKey) {
                return this.glanceUri(roomNameOrId, glanceKey);
            }

            @Override
            public Promise<URI> createRoomGlance(String roomNameOrId, String glanceKey) {
                return this.glanceUri(roomNameOrId, glanceKey);
            }

            @Override
            public Promise<URI> deleteRoomGlance(String roomNameOrId, String glanceKey) {
                return this.glanceUri(roomNameOrId, glanceKey);
            }

            @Override
            public Promise<URI> updateRoomAddonUiForUser(String roomNameOrId, String hipchatUserIdOrEmail) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/ui/room/{id_or_name}/user/{user_id_or_email}", roomNameOrId, hipchatUserIdOrEmail));
            }

            @Override
            public Promise<URI> updateRoomAddonUi(String roomNameOrId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/ui/room/{id_or_name}", roomNameOrId));
            }

            @Override
            public Promise<URI> updateAddonUiForUser(String userIdOrEmail) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/ui/user/{user_id_or_email}", userIdOrEmail));
            }

            @Override
            public Promise<URI> roomExternalPage(String roomNameOrId, String externalPageKey) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}/extension/externalPage/{key}", roomNameOrId, externalPageKey));
            }

            private Promise<URI> glanceUri(String roomNameOrId, String glanceKey) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}/extension/glance/{key}", roomNameOrId, glanceKey));
            }

            @Override
            public Promise<URI> getRoomWebPanel(String roomNameOrId, String webPanelKey) {
                return this.webPanelUri(roomNameOrId, webPanelKey);
            }

            @Override
            public Promise<URI> createRoomWebPanel(String roomNameOrId, String webPanelKey) {
                return this.webPanelUri(roomNameOrId, webPanelKey);
            }

            @Override
            public Promise<URI> deleteRoomWebPanel(String roomNameOrId, String webPanelKey) {
                return this.webPanelUri(roomNameOrId, webPanelKey);
            }

            private Promise<URI> webPanelUri(String roomNameOrId, String webPanelKey) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/room/{id_or_name}/extension/webPanel/{key}", roomNameOrId, webPanelKey));
            }

            @Override
            public Promise<URI> getAddon(String addonId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/{id_or_name}", addonId));
            }

            @Override
            public Promise<URI> updateAddon(String addonId) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/{id_or_name}", addonId));
            }

            @Override
            public Promise<URI> inviteUser(String email, String name, Option<String> title) {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/invite/user", new Object[0]));
            }

            @Override
            public Promise<URI> createAddonLink() {
                return ((Promise)authToken.get()).map(this.buildURI(api, "/v2/addon/link", new Object[0]));
            }

            @Override
            public Promise<URI> invokeAddonLink(String token) {
                return Promises.promise((Object)UriBuilder.fromPath((String)api).path("/v2/addon/link/{token}").build(new Object[]{token}));
            }
        };
    }
}

