/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat;

import com.atlassian.cache.compat.CompatibilityCacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCacheVersionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityCacheFactory.class);
    private static final String LOADING_CACHE_CLASS = "com.google.common.cache.LoadingCache";
    private static boolean IS_GUAVA_11;

    public static boolean isGuavaVersion11() {
        return IS_GUAVA_11;
    }

    static {
        try {
            GuavaCacheVersionChecker.class.getClassLoader().loadClass(LOADING_CACHE_CLASS);
            IS_GUAVA_11 = true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("LoadingCache not found, assuming Guava 10", (Throwable)e);
            IS_GUAVA_11 = false;
        }
    }
}

