/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.sidebar;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.content.ContentRenderer;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRenderer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SoftwareProjectContentRenderer
implements ProjectContentRenderer {
    public static final String WEB_PANEL_LOCATION = "jira.project.software.sidebar";
    @VisibleForTesting
    static final String SIDEBAR_COLLAPSE_KEY = "sidebar-collapsed-by-default";
    private final ProjectContextPopulator contextPopulator;
    private final ContentRenderer contentRenderer;
    private final PageBuilderService pageBuilderService;

    @Autowired
    public SoftwareProjectContentRenderer(@ComponentImport ProjectContextPopulator contextPopulator, @ComponentImport ContentRenderer contentRenderer, @ComponentImport PageBuilderService pageBuilderService) {
        this.contextPopulator = contextPopulator;
        this.contentRenderer = contentRenderer;
        this.pageBuilderService = pageBuilderService;
    }

    public String render(Project project, String selectedItemId) {
        Map projectContext = this.contextPopulator.populateWithProject(project);
        projectContext.put("selectedItemId", StringUtils.trimToEmpty((String)selectedItemId));
        this.pageBuilderService.assembler().data().requireData(SIDEBAR_COLLAPSE_KEY, Boolean.valueOf(true));
        return this.contentRenderer.render(WEB_PANEL_LOCATION, projectContext);
    }
}

