/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.sidebar;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypesDarkFeature;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItemService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectNavigationItemContextProvider
implements ContextProvider {
    public static final String ACTIVE_SPRINT_WEB_ITEM_ID = "com.pyxis.greenhopper.jira:project-sidebar-work-scrum";
    public static final String KANBAN_BOARD_WEB_ITEM_ID = "com.pyxis.greenhopper.jira:project-sidebar-work-kanban";
    public static final String REPORTS_WEB_ITEM_ID = "com.atlassian.jira.jira-projects-plugin:report-page";
    public static final String RELEASES_WEB_ITEM_ID = "com.atlassian.jira.jira-projects-plugin:release-page";
    public static final String SIDEBAR_NAVIGATION_ID = "sidebar-navigation-panel";
    @VisibleForTesting
    public static final String RELEASE_ICON_FOR_SOFTWARE = "icon-sidebar-release";
    @VisibleForTesting
    public static final String RELEASE_LABEL_FOR_SOFTWARE_KEY = "project.sidebar.navigation.release.for.software.label";
    private final NavigationItemService navigationItemService;
    private final ProjectContextPopulator contextPopulator;
    private final LicenseService licenseService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectTypesDarkFeature projectTypesDarkFeature;

    @Autowired
    public ProjectNavigationItemContextProvider(@ComponentImport NavigationItemService navigationItemService, @ComponentImport ProjectContextPopulator contextPopulator, LicenseService licenseService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ProjectTypesDarkFeature projectTypesDarkFeature) {
        this.navigationItemService = navigationItemService;
        this.contextPopulator = contextPopulator;
        this.licenseService = licenseService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectTypesDarkFeature = projectTypesDarkFeature;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map newContext = this.contextPopulator.populateWithProject((Project)Preconditions.checkNotNull((Object)context.get("project")));
        newContext.putAll(context);
        ArrayList<NavigationItem> items = new ArrayList<NavigationItem>();
        List mainNavigationItems = this.navigationItemService.getItemsInSection("jira.project.sidebar.navigation", newContext);
        if (this.isProjectBusinessLike(context)) {
            items.addAll(mainNavigationItems);
        } else {
            List<NavigationItem> navItems = this.hideReleasesForUnlicensedUsers(this.moveReportsAfterActiveItems(mainNavigationItems));
            items.addAll(this.relabelVersionsToReleases(navItems));
        }
        items.addAll(this.navigationItemService.getItemsInSection("jira.project.sidebar.plugins.navigation", newContext));
        items.addAll(this.navigationItemService.getItemsInSection("jira.project.sidebar.legacy.tabs.navigation", newContext));
        newContext.put("items", items);
        newContext.put("tierOne", true);
        newContext.put("id", SIDEBAR_NAVIGATION_ID);
        return newContext;
    }

    private List<NavigationItem> relabelVersionsToReleases(List<NavigationItem> navItems) {
        ArrayList newNavItems = Lists.newArrayList(navItems);
        for (int i = 0; i < newNavItems.size(); ++i) {
            NavigationItem navigationItem = (NavigationItem)newNavItems.get(i);
            if (!RELEASES_WEB_ITEM_ID.equals(navigationItem.getId())) continue;
            NavigationItem.Builder builder = NavigationItem.builder();
            NavigationItem newReleaseWebItem = builder.setHref(navigationItem.getHref()).setIconClass(RELEASE_ICON_FOR_SOFTWARE).setId(navigationItem.getId()).setLabel(this.jiraAuthenticationContext.getI18nHelper().getText(RELEASE_LABEL_FOR_SOFTWARE_KEY)).build();
            newNavItems.remove(i);
            newNavItems.add(i, newReleaseWebItem);
            break;
        }
        return Collections.unmodifiableList(newNavItems);
    }

    private List<NavigationItem> moveReportsAfterActiveItems(List<NavigationItem> itemsInSection) {
        ArrayList sortedNavigationItems = Lists.newArrayList(itemsInSection);
        Option activeSprintOrKanbanItem = Option.none();
        Option reportsNavItem = Option.none();
        Option releasesNavItem = Option.none();
        for (NavigationItem currentNavItem : sortedNavigationItems) {
            switch (currentNavItem.getId()) {
                case "com.pyxis.greenhopper.jira:project-sidebar-work-scrum": 
                case "com.pyxis.greenhopper.jira:project-sidebar-work-kanban": {
                    activeSprintOrKanbanItem = Option.option((Object)currentNavItem);
                    break;
                }
                case "com.atlassian.jira.jira-projects-plugin:report-page": {
                    reportsNavItem = Option.option((Object)currentNavItem);
                    break;
                }
                case "com.atlassian.jira.jira-projects-plugin:release-page": {
                    releasesNavItem = Option.option((Object)currentNavItem);
                }
            }
        }
        if (activeSprintOrKanbanItem.isDefined() && reportsNavItem.isDefined()) {
            sortedNavigationItems.remove(reportsNavItem.get());
            if (releasesNavItem.isDefined()) {
                sortedNavigationItems.remove(releasesNavItem.get());
                this.insertAfter(sortedNavigationItems, (NavigationItem)activeSprintOrKanbanItem.get(), (NavigationItem)releasesNavItem.get());
                this.insertAfter(sortedNavigationItems, (NavigationItem)releasesNavItem.get(), (NavigationItem)reportsNavItem.get());
            } else {
                this.insertAfter(sortedNavigationItems, (NavigationItem)activeSprintOrKanbanItem.get(), (NavigationItem)reportsNavItem.get());
            }
        }
        return sortedNavigationItems;
    }

    private void insertAfter(List<NavigationItem> list, NavigationItem elementToFind, NavigationItem elementToInsert) {
        int index = list.indexOf(elementToFind);
        list.add(Math.min(index + 1, list.size()), elementToInsert);
    }

    private List<NavigationItem> hideReleasesForUnlicensedUsers(List<NavigationItem> itemsInSection) {
        if (!this.licenseService.isSoftwareUser(this.jiraAuthenticationContext.getLoggedInUser())) {
            return (List)itemsInSection.stream().filter(item -> !RELEASES_WEB_ITEM_ID.equals(item.getId())).collect(CollectorsUtil.toImmutableList());
        }
        return itemsInSection;
    }

    private boolean isProjectBusinessLike(Map<String, Object> context) {
        boolean projectTypesDisabled = !this.projectTypesDarkFeature.isEnabled();
        boolean hasNoBoards = !context.containsKey("boards") || ((List)context.get("boards")).size() == 0;
        return projectTypesDisabled && hasNoBoards;
    }
}

