/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.roles;

import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.jira.software.api.roles.SoftwareApplicationKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ExportAsService
@Service
public class DefaultLicenseService
implements LicenseService {
    private final ApplicationAuthorizationService applicationAuthService;
    private final JiraLicenseManager jiraLicenseManager;

    @Autowired
    public DefaultLicenseService(@ComponentImport ApplicationAuthorizationService applicationAuthService, @ComponentImport JiraLicenseManager jiraLicenseManager) {
        this.applicationAuthService = (ApplicationAuthorizationService)Preconditions.checkNotNull((Object)applicationAuthService);
        this.jiraLicenseManager = (JiraLicenseManager)Preconditions.checkNotNull((Object)jiraLicenseManager);
    }

    public boolean hasSoftwareLicense() {
        return !this.isSoftwareRoleEnabled() || this.applicationAuthService.isApplicationInstalledAndLicensed(SoftwareApplicationKey.SOFTWARE_KEY);
    }

    public boolean hasActiveSoftwareLicense() {
        if (!this.isSoftwareRoleEnabled()) {
            return true;
        }
        Option optionalLicense = this.jiraLicenseManager.getLicense(SoftwareApplicationKey.SOFTWARE_KEY);
        return optionalLicense.isDefined() && !((LicenseDetails)optionalLicense.get()).isExpired();
    }

    public boolean isSoftwareUserLimitExceeded() {
        return this.isSoftwareRoleEnabled() && this.applicationAuthService.isExceeded(SoftwareApplicationKey.SOFTWARE_KEY);
    }

    public boolean isSoftwareUser(ApplicationUser user) {
        return !this.isSoftwareRoleEnabled() || this.applicationAuthService.canUseApplication(user, SoftwareApplicationKey.SOFTWARE_KEY);
    }

    private boolean isSoftwareRoleEnabled() {
        return this.applicationAuthService.rolesEnabled();
    }
}

