/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.reports;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.report.ReportSubTaskFetcher;
import com.atlassian.jira.plugin.report.SubTaskInclusionOption;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.software.api.roles.SoftwareLicenseService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VersionWorkloadReport
extends AbstractReport {
    private ApplicationProperties applicationProperties;
    private IssueTypeSchemeManager issueTypeSchemeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private Map<String, Long> issueTypeTotals = new HashMap<String, Long>();
    private PermissionManager permissionManager;
    private ReportSubTaskFetcher reportSubTaskFetcher;
    private SearchService searchService;
    private final SoftwareLicenseService softwareLicenseService;
    private Map<String, String> user2FullNames = new HashMap<String, String>();
    private Map<String, List<Issue>> user2Issues = new HashMap<String, List<Issue>>();
    private Map<String, Long> user2RemainingTime = new HashMap<String, Long>();
    private Map<String, Map<String, Long>> userSummaryTotals = new HashMap<String, Map<String, Long>>();
    private UserManager userManager;
    private VersionManager versionManager;
    private long grandTotal = 0L;
    private String displayUnknown;

    public VersionWorkloadReport(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport IssueTypeSchemeManager issueTypeSchemeManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport ReportSubTaskFetcher reportSubTaskFetcher, @ComponentImport SearchService searchService, SoftwareLicenseService softwareLicenseService, @ComponentImport UserManager userManager, @ComponentImport VersionManager versionManager) {
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.reportSubTaskFetcher = reportSubTaskFetcher;
        this.searchService = searchService;
        this.softwareLicenseService = softwareLicenseService;
        this.userManager = userManager;
        this.versionManager = versionManager;
    }

    public boolean showReport() {
        if (!this.applicationProperties.getOption("jira.option.timetracking")) {
            return false;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        return this.softwareLicenseService.isSoftwareUser(user);
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        ApplicationUser remoteUser = action.getLoggedInApplicationUser();
        this.displayUnknown = (String)reqParams.get("displayUnknown");
        String versionId = (String)reqParams.get("versionId");
        String subtaskInclusionKey = (String)reqParams.get("subtaskInclusion");
        SubTaskInclusionOption subtaskInclusion = SubTaskInclusionOption.fromKey((String)subtaskInclusionKey);
        Collection<Issue> issues = this.loadIssues(remoteUser, versionId, subtaskInclusion);
        this.calculateSummaryTotals(issues);
        Collection<String> assigneeUserNames = this.getAssigneeUserNames();
        Version version = this.versionManager.getVersion(Long.valueOf(Long.parseLong(versionId)));
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("report", (Object)this);
        velocityParams.put("action", action);
        velocityParams.put("version", version);
        velocityParams.put("displayUnknown", this.displayUnknown);
        velocityParams.put("issueTypes", this.loadIssueTypes(action.getSelectedProjectObject()));
        velocityParams.put("assigneeUserNames", assigneeUserNames);
        return this.getDescriptor().getHtml("view", velocityParams);
    }

    public void validate(ProjectActionSupport action, Map params) {
        Project project;
        super.validate(action, params);
        String selectedProjectId = (String)params.get("selectedProjectId");
        if (!StringUtils.isEmpty((String)selectedProjectId)) {
            action.setSelectedProjectId(Long.valueOf(Long.parseLong(selectedProjectId)));
        }
        if ((project = action.getSelectedProjectObject()) == null || !action.getBrowsableProjects().contains(project)) {
            action.addErrorMessage(this.getI18nBean().getText("report.error.project.id.not.found"));
            return;
        }
        String versionId = (String)params.get("versionId");
        if (StringUtils.isEmpty((String)versionId)) {
            action.addError("versionId", this.getI18nBean().getText("report.versionworkload.version.is.required"));
        } else if (Long.parseLong(versionId) == -2L || Long.parseLong(versionId) == -1L) {
            action.addError("versionId", this.getI18nBean().getText("report.versionworkload.please.select.an.actual.version"));
        } else if (this.versionManager.getVersion(Long.valueOf(Long.parseLong(versionId))) == null) {
            action.addError("versionId", this.getI18nBean().getText("report.versionworkload.version.does.not.exist"));
        }
    }

    private Collection<Issue> loadIssues(ApplicationUser remoteUser, String versionId, SubTaskInclusionOption subtaskInclusion) throws Exception {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = queryBuilder.where().unresolved();
        if (versionId != null) {
            whereBuilder.and().fixVersion(versionId);
        }
        queryBuilder.orderBy().priority(SortOrder.DESC);
        List issues = this.searchService.search(remoteUser, queryBuilder.buildQuery(), PagerFilter.getUnlimitedFilter()).getIssues();
        LinkedHashSet<Issue> result = new LinkedHashSet<Issue>(issues);
        if (subtaskInclusion != null) {
            List subTasks = this.reportSubTaskFetcher.getSubTasks(remoteUser, issues, subtaskInclusion, true);
            Collections.sort(subTasks, new IssueCreateComparator());
            result.addAll(subTasks);
        }
        return result;
    }

    private List<IssueType> loadIssueTypes(Project project) {
        return new ArrayList<IssueType>(this.issueTypeSchemeManager.getIssueTypesForProject(project));
    }

    private void calculateSummaryTotals(Collection<Issue> issues) {
        String unassignedKey = this.getI18nBean().getText("common.concepts.unassigned");
        for (Issue issue : issues) {
            String assignee;
            ApplicationUser assigneeUser = issue.getAssignee();
            if (assigneeUser != null) {
                assignee = assigneeUser.getName();
                if (this.user2FullNames.get(assignee) == null) {
                    this.user2FullNames.put(assignee, assigneeUser.getDisplayName());
                }
            } else {
                assignee = unassignedKey;
            }
            if (this.userSummaryTotals.get(assignee) == null) {
                this.userSummaryTotals.put(assignee, new HashMap());
            }
            String issueTypeId = issue.getIssueTypeObject().getId();
            Long issueEstimate = issue.getEstimate();
            this.addToTotalTime(issueTypeId, issueEstimate);
            this.addToeUserTotalTime(assignee, issueEstimate);
            this.addToUserTypeTotalTime(assignee, issueTypeId, issueEstimate);
            this.buildUser2Issues(issue, assignee, unassignedKey);
        }
    }

    private void addToUserTypeTotalTime(String assignee, String issueType, Long issueEstimate) {
        Map<String, Long> userTotalMap = this.userSummaryTotals.get(assignee);
        Long estimateSoFar = userTotalMap.get(issueType);
        if (issueEstimate != null) {
            if (estimateSoFar == null) {
                userTotalMap.put(issueType, issueEstimate);
            } else {
                userTotalMap.put(issueType, estimateSoFar + issueEstimate);
            }
        }
    }

    private void addToeUserTotalTime(String assignee, Long issueEstimate) {
        Long lRemainingTime = this.user2RemainingTime.get(assignee);
        if (issueEstimate != null) {
            if (lRemainingTime == null) {
                lRemainingTime = 0L;
            }
            long remainingTime = lRemainingTime;
            this.user2RemainingTime.put(assignee, remainingTime += issueEstimate.longValue());
        }
    }

    private void addToTotalTime(String issueType, Long issueEstimate) {
        Long currentTypeTotal = this.issueTypeTotals.get(issueType);
        if (issueEstimate != null) {
            if (currentTypeTotal == null) {
                this.issueTypeTotals.put(issueType, issueEstimate);
            } else {
                this.issueTypeTotals.put(issueType, currentTypeTotal + issueEstimate);
            }
            this.grandTotal += issueEstimate.longValue();
        }
    }

    private void buildUser2Issues(Issue issue, String assignee, String unassignedKey) {
        List<Issue> unassignedList = this.user2Issues.get(unassignedKey);
        if (assignee == null) {
            if (unassignedList == null) {
                unassignedList = new ArrayList<Issue>();
                this.user2Issues.put(unassignedKey, unassignedList);
            }
            unassignedList.add(issue);
        } else {
            List<Issue> assigneeList = this.user2Issues.get(assignee);
            if (assigneeList == null) {
                assigneeList = new ArrayList<Issue>();
                this.user2Issues.put(assignee, assigneeList);
            }
            assigneeList.add(issue);
        }
    }

    private Collection<String> getAssigneeUserNames() {
        ArrayList<String> result = new ArrayList<String>(this.user2Issues.keySet());
        Collections.sort(result, new AssigneeComparator());
        return result;
    }

    private I18nHelper getI18nBean() {
        return this.getDescriptor().getI18nBean();
    }

    public String getTotalTimeForUserByIssueType(String user, String type) {
        Long time = null;
        Map<String, Long> userTotals = this.userSummaryTotals.get(user);
        time = userTotals.get(type);
        return this.getNiceTimeDuration(time);
    }

    public String getGrandTotal() {
        return this.getNiceTimeDuration(this.grandTotal);
    }

    public boolean isIssueVisible(Issue issue, ApplicationUser user) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue must not be null!");
        }
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
    }

    public Collection<Issue> getIssuesByType(String user, String typeId) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue issue : this.user2Issues.get(user)) {
            if (!issue.getIssueTypeObject().getId().equals(typeId)) continue;
            result.add(issue);
        }
        return result;
    }

    public Collection<Issue> getDisplayableIssues(String user, String typeId) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue issue : this.user2Issues.get(user)) {
            if (!issue.getIssueTypeObject().getId().equals(typeId) || this.getNiceTimeEstimateDuration(issue).equals(this.getI18nBean().getText("report.versionworkload.no.estimate")) && this.displayUnknown != null && this.displayUnknown.equals("no")) continue;
            result.add(issue);
        }
        return result;
    }

    public String getRemainingTime(String assignee) {
        Long time = this.user2RemainingTime.get(assignee);
        return this.getNiceTimeDuration(time);
    }

    public String getIssueTypeTotal(String issueType) {
        Long time = this.issueTypeTotals.get(issueType);
        return this.getNiceTimeDuration(time);
    }

    private String getNiceTimeDuration(long duration) {
        return ComponentAccessor.getJiraDurationUtils().getFormattedDuration(Long.valueOf(duration), this.getI18nBean().getLocale());
    }

    private String getNiceTimeDuration(Long duration) {
        if (duration == null) {
            return this.getI18nBean().getText("report.versionworkload.no.estimate");
        }
        return this.getNiceTimeDuration((long)duration);
    }

    public String getNiceTimeEstimateDuration(Issue issue) {
        return this.getNiceTimeDuration(issue.getEstimate());
    }

    public String getAssigneeFullName(String username) {
        String userFullName = this.user2FullNames.get(username);
        return userFullName == null ? username : userFullName;
    }

    private class AssigneeComparator
    implements Comparator<String> {
        private AssigneeComparator() {
        }

        @Override
        public int compare(String l1, String l2) {
            if (l1.equals(VersionWorkloadReport.this.getI18nBean().getText("common.concepts.unassigned"))) {
                return 1;
            }
            if (l2.equals(VersionWorkloadReport.this.getI18nBean().getText("common.concepts.unassigned"))) {
                return -1;
            }
            ApplicationUser user1 = VersionWorkloadReport.this.userManager.getUserByKeyEvenWhenUnknown(l1);
            if (user1 == null) {
                String errMsg = "Could not find user " + l1;
                throw new IllegalArgumentException(errMsg);
            }
            ApplicationUser user2 = VersionWorkloadReport.this.userManager.getUserByKeyEvenWhenUnknown(l2);
            if (user2 == null) {
                String errMsg = "Could not find user " + l2;
                throw new IllegalArgumentException(errMsg);
            }
            return user1.getDisplayName().compareTo(user2.getDisplayName());
        }
    }

    private static class IssueCreateComparator
    implements Comparator<Issue> {
        private IssueCreateComparator() {
        }

        @Override
        public int compare(Issue issue, Issue issue1) {
            return issue.getCreated().compareTo(issue1.getCreated());
        }
    }
}

