/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.reports;

import com.atlassian.configurable.ValuesGenerator;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class VersionValuesGenerator
implements ValuesGenerator<Long> {
    static final long RELEASED_HEADING_ID = -1L;
    static final long UNRELEASED_HEADING_ID = -2L;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final VersionManager versionManager;

    public VersionValuesGenerator(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport VersionManager versionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.versionManager = versionManager;
    }

    public Map<Long, String> getValues(Map params) {
        GenericValue projectGV = (GenericValue)params.get("project");
        if (projectGV == null) {
            return new LinkedHashMap<Long, String>();
        }
        Collection unreleasedVersions = this.versionManager.getVersionsUnreleased(projectGV.getLong("id"), false);
        LinkedHashMap<Long, String> unreleasedVersionOptions = new LinkedHashMap<Long, String>(unreleasedVersions.size());
        if (!unreleasedVersions.isEmpty()) {
            unreleasedVersionOptions.put(-2L, this.jiraAuthenticationContext.getI18nHelper().getText("common.filters.unreleasedversions"));
        }
        for (Version version : unreleasedVersions) {
            unreleasedVersionOptions.put(version.getId(), "- " + version.getName());
        }
        Collection releasedVersions = this.versionManager.getVersionsReleased(projectGV.getLong("id"), false);
        LinkedHashMap<Long, String> releasedVersionOptions = new LinkedHashMap<Long, String>(releasedVersions.size());
        if (!releasedVersions.isEmpty()) {
            releasedVersionOptions.put(-1L, this.jiraAuthenticationContext.getI18nHelper().getText("common.filters.releasedversions"));
        }
        for (Version version : releasedVersions) {
            releasedVersionOptions.put(version.getId(), "- " + version.getName());
        }
        int size = unreleasedVersionOptions.size() + releasedVersionOptions.size();
        LinkedHashMap<Long, String> versionOptions = new LinkedHashMap<Long, String>(size);
        versionOptions.putAll(unreleasedVersionOptions);
        versionOptions.putAll(releasedVersionOptions);
        return versionOptions;
    }
}

