/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.project;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypesDarkFeature;
import com.atlassian.jira.software.api.project.SoftwareProjectTypeService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ExportAsService
public class DefaultSoftwareProjectTypeService
implements SoftwareProjectTypeService {
    private final ProjectTypesDarkFeature darkFeature;

    @Autowired
    public DefaultSoftwareProjectTypeService(@ComponentImport ProjectTypesDarkFeature darkFeature) {
        this.darkFeature = darkFeature;
    }

    public static ProjectTypeKey getProjectTypeKey() {
        return SOFTWARE_TYPE;
    }

    public boolean isSoftwareProject(Project project) {
        if (this.darkFeature.isEnabled()) {
            return project != null && SOFTWARE_TYPE.equals((Object)project.getProjectTypeKey());
        }
        return true;
    }
}

