/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software.internal.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projects.unlicensed.UnlicensedProjectPageRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.software.api.project.SoftwareProjectTypeService;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleasesPageAccessControlFilter
extends AbstractHttpFilter {
    private static final Pattern URL_PATTERN = Pattern.compile("\\/projects\\/([^\\/?]+)");
    private static final String UNLICENSED_PAGE_WEB_RESOURCE_KEY = "com.atlassian.jira.plugins.jira-software-plugin:unlicensed-page-web-resource";
    @Autowired
    @ComponentImport
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @Autowired
    @ComponentImport
    private ProjectManager projectManager;
    @Autowired
    @ComponentImport
    private SoyTemplateRenderer soyTemplateRenderer;
    @Autowired
    @ComponentImport
    private UnlicensedProjectPageRenderer unlicensedProjectPageRenderer;
    @Autowired
    private SoftwareProjectTypeService softwareProjectTypeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isRequestForReleasesPage(request) || !this.isSoftwareProject(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (user == null) {
            response.sendRedirect(this.getLoginRedirect(request));
        } else if (!this.licenseService.isSoftwareUser(user)) {
            try {
                response.getWriter().write(this.getUnlicensedPageHtml(request));
            }
            finally {
                response.getWriter().close();
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String getLoginRedirect(HttpServletRequest request) {
        String continuationUrl = request.getPathInfo() + "?" + request.getQueryString();
        return request.getContextPath() + "/login.jsp?os_destination=" + JiraUrlCodec.encode((String)continuationUrl, (String)"UTF-8");
    }

    private String getUnlicensedPageHtml(HttpServletRequest request) {
        RequiredResources requiredResources = this.pageBuilderService.assembler().resources();
        requiredResources.requireWebResource(UNLICENSED_PAGE_WEB_RESOURCE_KEY);
        String projectRedirectUrl = request.getContextPath() + request.getPathInfo() + "/issues";
        String content = this.unlicensedProjectPageRenderer.render(requiredResources, SoftwareProjectTypeService.SOFTWARE_TYPE, projectRedirectUrl);
        return this.soyTemplateRenderer.render(UNLICENSED_PAGE_WEB_RESOURCE_KEY, "JIRA.Software.Templates.Unlicensed.page", (Map)ImmutableMap.of((Object)"content", (Object)content));
    }

    private boolean isRequestForReleasesPage(HttpServletRequest request) {
        String requestedPage = request.getParameter("selectedItem");
        return "com.atlassian.jira.jira-projects-plugin:release-page".equals(requestedPage);
    }

    private boolean isSoftwareProject(HttpServletRequest request) {
        String projectKey = this.getProjectKeyFromRequest(request);
        if (!JiraKeyUtils.validProjectKey((String)projectKey)) {
            return false;
        }
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        return this.softwareProjectTypeService.isSoftwareProject(project);
    }

    private String getProjectKeyFromRequest(HttpServletRequest request) {
        Matcher matcher = URL_PATTERN.matcher(request.getPathInfo());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

