/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.software;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.software.internal.sidebar.ProjectContentRendererRegistrar;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class Launcher
implements LifecycleAware,
InitializingBean {
    static final String PLUGIN_KEY = "com.atlassian.jira.plugins.jira-software-plugin";
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);
    private final EventPublisher eventPublisher;
    private final ProjectContentRendererRegistrar projectContentRendererRegistrar;
    @GuardedBy(value="this")
    private final Set<LifecycleEvent> lifecycleEvents = EnumSet.noneOf(LifecycleEvent.class);

    @Autowired
    public Launcher(@ComponentImport EventPublisher eventPublisher, ProjectContentRendererRegistrar projectContentRendererRegistrar) {
        this.eventPublisher = eventPublisher;
        this.projectContentRendererRegistrar = projectContentRendererRegistrar;
    }

    public void afterPropertiesSet() {
        this.registerListener();
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
        this.unregisterListener();
        try {
            this.halt();
        }
        catch (Exception ex) {
            LOG.error("Unexpected error during halt", (Throwable)ex);
        }
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
        }
    }

    private void onLifecycleEvent(LifecycleEvent event) {
        if (this.isLifecycleReady(event)) {
            this.unregisterListener();
            try {
                this.launch();
            }
            catch (Exception ex) {
                LOG.error("Unexpected error during launch", (Throwable)ex);
            }
        }
    }

    private synchronized boolean isLifecycleReady(LifecycleEvent event) {
        return this.lifecycleEvents.add(event) && this.lifecycleEvents.size() == LifecycleEvent.values().length;
    }

    private void launch() throws Exception {
        this.projectContentRendererRegistrar.registerContentRenderer();
    }

    private void halt() throws Exception {
        this.projectContentRendererRegistrar.unregisterContentRenderer();
    }

    private void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    private void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    static enum LifecycleEvent {
        AFTER_PROPERTIES_SET,
        PLUGIN_ENABLED,
        LIFECYCLE_AWARE_ON_START;

    }
}

