[#ftl]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" --]
[#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--]
[#-- @ftlvariable name="wbspec" type="com.cenqua.fisheye.web.WaybackSpec" --]
[#include "../util.ftl"]
[#macro changesetHeader cs repcfg showFiles=true user='']
[#-- @ftlvariable name="cs" type="com.cenqua.fisheye.rep.ChangeSet" --]
[#-- @ftlvariable name="user" type="com.atlassian.fecru.user.FecruUser" --]
[#if user?has_content]
    [#assign userUrl="${siteurl}/${navBuilder.user(user)}"/]
    [#assign userAvatar="${avatarTypeInfo.getFullAvatarUrl(user, 48)}"/]
    [#assign userName="${user.username}"/]
    [#assign displayName="${user.displayName}"/]
[#else]
    [#assign userUrl="${siteurl}/${navBuilder.committer(cs.repName, cs.author)}"/]
    [#assign userAvatar="${avatarTypeInfo.getFullUnknownAvatarUrl(48)}"/]
    [#assign userName="${cs.author}"/]
    [#assign displayName="${cs.author}"/]
[/#if]
<table width="100%">
    <tr>
        <td style="vertical-align: top; width: 48px; padding-right: 16px" rowspan="4">
            [@a href="${userUrl}"]
                [@img src="${userAvatar}" height="48" width="48"/]
            [/@a]
        </td>
        <td style="vertical-align: top;">
            [@a href="${userUrl}"]${displayName?html}[/@a]
            changed ${cs.revisionInfosCount} [#if cs.revisionInfosCount == 1]file[#else]files[/#if]
        </td>
        <td style="vertical-align:top; text-align: right">
            <span title="${cs.dateValue?string("EEE, dd MMMM yyyy, HH:mm:ss ZZ")}">
                ${cs.dateValue?string("MMM dd yyyy HH:mm")}
            </span>
        </td>
    </tr>
    <tr>
        <td style="line-height: 24px" colspan="2">
            [@img src="${siteurl}/${staticPath}/2static/images/email/single_changeset_16.png" style="vertical-align: middle;" width="16px" height="16px"/]
            [@a href="${siteurl}/${navBuilder.changeset(cs.repName, cs.id)}" extraStyle="font-size: 16px; font-weight: bold; vertical-align: middle;"]${cs.displayId?html}[/@a]
            [#if cs.branch?has_content]
            [@img src="${siteurl}/${staticPath}/2static/images/email/single_branch_16.png" style="vertical-align: middle;" width="16px" height="16px"/]
            [@a href="${siteurl}/${navBuilder.changelog(cs.repName, cs.branch)}"]${cs.branch?html}[/@a]
            [/#if]
            on [@a href="${siteurl}/${navBuilder.changelog(cs.repName)}"]${cs.repName?html}[/@a]
        </td>
    </tr>

    <tr>
        <td colspan="2">
            [@mainSection]
                ${freemarkerUtil.formatChangesetComment(repcfg, cs)}
            [/@mainSection]
        </td>
    </tr>

    [#if showFiles]
    <tr>
        <td colspan="2">
            <table cellpadding="0">
                [#list cs.revisionsIterable.iterator() as rev]
                    [#if rev_index > 14]
                        <tr>
                            <td colspan=99>
                                &hellip; ${cs.revisionInfosCount - rev_index} more files in changeset
                            </td>
                        </tr>
                        [#break]
                    [/#if]
                    <tr>
                        [#assign linkColour="#003366"/]
                        [#if rev.dead]
                            [#assign linkColour="#B22222"/] [#-- firebrick --]
                        [#elseif rev.added]
                            [#assign linkColour="#006400"/] [#-- darkgreen --]
                        [#elseif rev.move || rev.copy]
                            [#assign linkColour="#d2691e"/] [#-- chocolate --]
                        [/#if]
                        <td style="padding-right: 10px; vertical-align: middle;">
                            [@a href="${siteurl}/${navBuilder.browse(wbspec!, cs.repName, rev.path)}" color="${linkColour}"]${freemarkerUtil.getAbbreviatedPath(rev.path, 50)?html}[/@a]
                        </td>
                        <td style="padding: 0 2px; font-size: 0.9em; vertical-align: middle; white-space: nowrap;">
                            [#if !rev.binary]
                                ([#if !rev.dead]+${rev.linesAdded},[/#if]-${rev.linesRemoved})
                            [#else]
                                (binary)
                            [/#if]
                        </td>
                        <td style="padding: 0 2px; font-size: 0.9em; vertical-align: middle; white-space: nowrap;">
                            <span style="padding-right: 2px">|</span>
                            [@a title="View file history" href="${siteurl}/${navBuilder.fileHistory(wbspec!, cs.repName, rev)}"]
                                History
                            [/@a]
                        </td>
                        <td style="padding: 0 2px; font-size: 0.9em; vertical-align: middle; white-space: nowrap;">
                            <span style="padding-right: 2px">|</span>
                            [@a title="View full source" href="${siteurl}/${navBuilder.browseSource(wbspec!, cs.repName, rev.path, rev.revision)}"]
                                Source
                            [/@a]
                        </td>
                        [#if rev.diffRevision?has_content]
                        <td style="padding: 0 2px; font-size: 0.9em; vertical-align: middle; white-space: nowrap;">
                            <span style="padding-right: 2px">|</span>
                            [@a href="${siteurl}/${navBuilder.browseDiff(wbspec!, cs.repName, rev)}"]
                                Diff
                            [/@a]
                        </td>
                        [/#if]
                    </tr>
                [/#list]
            </table>
        </td>
    </tr>
    [/#if]
</table>
[/#macro]
