[#ftl]
[#-- @ftlvariable name="changesets" type="java.util.List<com.cenqua.fisheye.web.DefaultWatchManager.ChangeSetData>" --]
[#-- @ftlvariable name="repname" type="java.lang.String" --]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#include "fisheye-layout.ftl"]
[@layout]
[#setting time_zone="${timezone}"]
[#list changesets as csd]
${csd.cs.displayId} <${siteurl}/${navBuilder.changeset(repname, csd.cs.id)}>
${csd.cs.dateValue?string("EEE, dd MMMM yyyy, HH:mm:ss ZZ")}
Author: ${csd.cs.author}
Comment: ${csd.cs.comment}
[#if csd.cs.branch?has_content]
Branch: ${csd.cs.branch}
[/#if]
Files:
    [#list csd.revisionsIterator as rev]
    [#-- @ftlvariable name="rev" type="com.cenqua.fisheye.rep.FileRevision" --]
    [@compress single_line=true]
    [#if rev_index > 14]
    (${csd.cs.revisionInfosCount - rev_index} more files in changeset)
    [#break]
    [/#if]
    ${rev.path} ${rev.revision}
        [#if rev.binary]
        binary
            [#else]
            ([#if !rev.dead]+${rev.linesAdded}[/#if][#if !rev.added]-${rev.linesRemoved}[/#if])
        [/#if]
        [#if rev.dead]
        deleted[#if rev.move]/moved[/#if][#if rev.copy]/copied[/#if]
            [#elseif rev.added]
            new[#if rev.move]/moved[/#if][#if rev.copy]/copied[/#if]
        [/#if]
    [/@compress]
        [#nt]
    [/#list]
    [#if csd.canComment]
    comment on this changeset at <${csd.commentUrlAbs}>
    [/#if]
    [#if csd.canCreateReview]
    create a review for this changeset at <${csd.createReviewUrlAbs}>
    [/#if]
-----
[/#list]

To delete watches go to ${siteurl}/?dialog=/profile/showWatches.do

[/@layout]
