<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"-->
<#-- @ftlvariable name="siteurl" type="java.lang.String" -->
<#-- @ftlvariable name="frxComments" type="java.util.List<com.cenqua.crucible.model.Comment>"-->
<#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review"-->
<#-- @ftlvariable name="commentManager" type="com.cenqua.crucible.model.managers.CommentManager"-->
<#-- @ftlvariable name="formatter" type="com.cenqua.crucible.util.EmailAllCommentsFormatter"-->
<#include "crucible-layout.ftl">
<@layout review=review>
<#if !notificationEvent?exists>
This is a list of all comments for ${review.permaId}.
</#if>
<#if notificationEvent?exists>
${notificationEvent.review.permaId} has been summarized and closed by ${notificationEvent.actioner.displayName}.
</#if>

Review Summary: ${review.summary?default("No summary")}

<@render comments=review.comments prefix="General Comment by"/>

<@render comments=frxComments prefix="Revision Comment by"/>

</@layout>

<#macro render comments prefix width=65>
<#assign prevFile = ""/>
<#list comments as comment >
<#if !comment.draft && !comment.deleted>
<#assign file = commentManager.getFilePath(comment)/>
<#if file != "" && file != prevFile>
<#assign prevFile = file/>
----------------------------------------
File: ${file}
</#if>
${prefix} ${comment.user.displayName} on ${comment.createDate?string("dd MMMM yyyy, HH:mm")} <#if comment.defectRaised>defect</#if>
${siteurl}/cru/${review.permaId}#c${comment.id?c}

${formatter.wrapAndPrefixAndIndent(comment, width, "  ")}

<#list comment.commentsAndReplies as reply>
<#if reply.reply && !reply.draft && !reply.deleted>
<#assign depth = formatter.getIndentationDepth(reply)/>
${formatter.indent("Reply by " + reply.user.displayName + " on " + reply.createDate?string("dd MMMM yyyy, HH:mm"), depth)}
${formatter.wrapAndPrefixAndIndent(reply, width, "> ")}

</#if>
</#list>
</#if>
</#list>
</#macro>
