<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--><#t/>
<#-- @ftlvariable name="siteurl" type="java.lang.String" --><#t/>
<#-- @ftlvariable name="formatter" type="com.cenqua.crucible.util.EmailAllCommentsFormatter"--><#t/>
<#-- @ftlvariable name="rootComments" type="java.util.Set<com.cenqua.fisheye.util.Pair<com.cenqua.crucible.model.FileRevisionExtraInfo, com.cenqua.crucible.model.Comment>>"--><#t/>
<#-- @ftlvariable name="newComments" type="java.util.Set<com.cenqua.crucible.model.Comment>"--><#t/>
<#-- @ftlvariable name="commentNotes" type="java.util.Map<java.lang.String, java.lang.String>"--><#t/>
<#-- @ftlvariable name="fileAndCommentPair" type="com.cenqua.fisheye.util.Pair<com.cenqua.crucible.model.FileRevisionExtraInfo, com.cenqua.crucible.model.Comment>"--><#t/>
<#-- @ftlvariable name="comment" type="com.cenqua.crucible.model.Comment"--><#t/>
<#-- @ftlvariable name="prevFile" type="com.cenqua.crucible.model.FileRevisionExtraInfo"--><#t/>
<#macro commentListPlainText rootComments discriminator="New" newComments=[] commentNotes={}><#t/>
    <#assign width = 120/><#t/>
    <#assign firstGeneralComment = true/><#t/>
    <#assign discriminatorStart = ("******  " + discriminator + "  ")?right_pad(width, "*") /><#t/>
    <#assign discriminatorEnd = ""?right_pad(width, "*") /><#t/>
    <#list rootComments as fileAndCommentPair ><#t/>
        <#assign comment = fileAndCommentPair.second/><#t/>
        <#if !comment.isDraft() && !comment.isDeleted()><#t/>


            <#if !fileAndCommentPair.first?? && firstGeneralComment><#t/>
                <#assign fileName = "General Comments"/><#t/>
            </#if><#t/>
            <#if fileAndCommentPair.first?? && (!prevFile?? || fileAndCommentPair.first != prevFile)><#t/>
                <#assign prevFile = fileAndCommentPair.first/><#t/>
                <#assign fileName = fileAndCommentPair.first.fePath.name/><#t/>
            </#if><#t/>
            <#assign prefix=""/><#t/>
            <#assign linePrefix="    "/><#t/>
            <#if comment.isDefectRaised()><#t/>
                <#assign prefix="DEFECT: "/><#t/>
            </#if><#t/>
            <#if newComments?seq_contains(comment)><#t/>
                <#assign linePrefix="    "/><#t/>
${formatter.indentAndTruncate(linePrefix + discriminatorStart, 0, width)}
            </#if><#t/>
${linePrefix}${fileName} - ${siteurl}/cru/${comment.review.permaId}/#c${comment.id?c}
${linePrefix}${prefix}${comment.user.displayName} on ${comment.createDate?string("dd MMM yyyy, HH:mm")}
${formatter.wrapAndPrefixAndIndent(comment, width, linePrefix + "    ")}
            <#if commentNotes?? && commentNotes?keys?seq_contains(comment.permaId) && commentNotes[comment.permaId]?has_content><#t/>

${formatter.wrapAndPrefixAndIndent(commentNotes[comment.permaId], 0, width, linePrefix + "    ")}
            </#if><#t/>
            <#if newComments?seq_contains(comment)><#t/>
${formatter.indentAndTruncate(linePrefix + discriminatorEnd, 0, width)}
            </#if><#t/>
            <#list comment.commentsAndReplies as reply><#t/>

                <#if reply.reply && !reply.isDraft() && !reply.isDeleted()><#t/>
                    <#assign depth = formatter.getIndentationDepth(reply)/><#t/>
                    <#assign replyLinePrefix="    "/><#t/>
                    <#if newComments?seq_contains(reply)><#t/>
                        <#assign replyLinePrefix="    "/><#t/>
${formatter.indentAndTruncate(replyLinePrefix + discriminatorStart, depth, width)}
                    </#if><#t/>
${formatter.indent(replyLinePrefix + reply.user.displayName + " on " + reply.createDate?string("dd MMM yyyy, HH:mm"), depth)}
${formatter.wrapAndPrefixAndIndent(reply, width, replyLinePrefix + "    ")}
                    <#if commentNotes?? && commentNotes?keys?seq_contains(reply.permaId) && commentNotes[reply.permaId]?has_content><#t/>

${formatter.wrapAndPrefixAndIndent(commentNotes[reply.permaId], depth, width, replyLinePrefix + "    ")}
                    </#if><#t/>
                    <#if newComments?seq_contains(reply)><#t/>
${formatter.indentAndTruncate(replyLinePrefix + discriminatorEnd, depth, width)}
                    </#if><#t/>
                </#if><#t/>
            </#list><#t/>
        </#if><#t/>
    </#list><#t/>
</#macro><#t/>