[#ftl]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="share" type="com.cenqua.crucible.notification.batch.creators.ShareContentBatchCreator.Share" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" --]
[#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--]
[#include "../../shared/util.ftl"/]
[#assign tableHeaderStyle="color: #505050; padding: 0 5px 2px 0; text-align: left;"/]
[#macro shareFooter share]
    <table width="100%">
        [#if share.otherUsers?size > 0 || share.otherEmails?size > 0]
            <tr>
                <td style="${tableHeaderStyle}">
                    Also shared with:
                </td>
            </tr>
            <tr>
                <td>
                    <table>
                        [#list share.otherUsers as user]
                            <tr>
                                <td width="32">
                                    [@a href="${siteurl}/${navBuilder.user(user)}"]
                                        [@img src="${avatarTypeInfo.getFullAvatarUrl(user, 32)}" height="32" width="32"/]
                                    [/@a]
                                </td>
                                <td style="padding-right: 30px;">
                                    [@a href="${siteurl}/${navBuilder.user(user)}"]${user.displayName?html}[/@a]
                                </td>
                            </tr>
                        [/#list]
                        [#list share.otherEmails as email]
                            <tr>
                                <td width="32">
                                    [@a href=""]
                                        [@img src="${avatarTypeInfo.getFullUnknownAvatarUrl(32)}" height="32" width="32"/]
                                    [/@a]
                                </td>
                                <td style="padding-right: 30px;">
                                    [@a href="mailto:${email?html}"]${email?html}[/@a]
                                </td>
                            </tr>
                        [/#list]
                    </table>
                </td>
            </tr>
        [/#if]
        <tr style="font-size: 12px; line-height: 14px; color: #777777">
            <td>
                <div style="padding-top: 12px">
                    If you are having trouble accessing the link, please copy and paste the URL below into your browser:<br/>
                    <a style="text-decoration: none; color: #3C78B5" href="${share.url}">${share.url?html}</a>
                </div>
            </td>
        </tr>
    </table>
[/#macro]
