[#ftl]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" --]
[#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--]
[#include "review-participant-row.ftl"/]
[#include "../../shared/util.ftl"/]
[#assign tableHeaderStyle="color: #505050; font-weight: bold; padding: 15px 5px 2px 0; text-align: left; border-bottom: 1px dashed #BBB;"/]
[#macro reviewSummary review]
<table width="100%">
    [#if !review.isSnippet()]
    <tr>
        <th style="${tableHeaderStyle}">
            Participants
        </th>
    </tr>
    <tr>
        <td>
            <table>
                [#if !review.moderated || review.moderator != review.author]
                    [@participantRow participant=review.authorP role="Author"/]
                [/#if]
                [#if review.moderated]
                    [#assign role = "Moderator"/]
                    [#if review.moderator == review.author]
                        [#assign role = "Author & Moderator"/]
                    [/#if]
                    [@participantRow participant=review.moderatorP role=role/]
                [/#if]
                [#list review.reviewerParticipants as participant]
                    [@participantRow participant=participant role="Reviewer"/]
                [/#list]
            </table>
        </td>
    </tr>
    [#else]
    <tr>
        <th style="${tableHeaderStyle}">
            Author
        </th>
    </tr>
    <tr>
        <td>
            <table>
                <tr>
                    <td style="width: 32px">
                        [@a href="${siteurl}/${navBuilder.user(review.author)}"]
                            [@img src="${avatarTypeInfo.getFullAvatarUrl(review.author, 32)}" height="32" width="32"/]
                        [/@a]
                    </td>
                    <td>
                        ${review.author.displayName?html}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    [/#if]

    [#if !review.isSnippet() && review.description?has_content]
    <tr>
        <th style="${tableHeaderStyle}">
            Objectives
        </th>
    </tr>
    <tr>
        <td>
            ${freemarkerUtil.formatWikiText(review.description, review)}
        </td>
    </tr>
    [/#if]

    [#if !review.isSnippet() && review.state.closedState && review.summary?has_content]
    <tr>
        <th style="${tableHeaderStyle}">
            Summary
        </th>
    </tr>
    <tr>
        <td>
            ${freemarkerUtil.formatWikiText(review.summary, review)}
        </td>
    </tr>
    [/#if]
</table>
[/#macro]
