<#ftl>
<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"-->
<#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" -->
<#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" -->
<#-- @ftlvariable name="segmentDataList" type="java.util.List<com.cenqua.crucible.notification.batch.creators.ReminderBatchCreator.ReviewReminderSegment>" -->
<#-- @ftlvariable name="siteurl" type="java.lang.String" -->
<#-- @ftlvariable name="staticPath" type="java.lang.String" -->
<#include "crucible-layout.ftl"/><#t/>
<#include "../../shared/util.ftl"/><#t/>
<#include "review-header.ftl"/><#t/>

<#macro infoGroup padding="0" margin="0" extraStyle=""><#t/>
    <p style="padding:${padding};margin:${margin};${extraStyle}"><#nested /></p><#t/>
</#macro><#t/>

<#macro dueDateBlock review dueDateString><#t/>
    <@a href="${siteurl}/${navBuilder.review(review)}"
        color="#FFF" title="${review.permaId?html}"
        extraStyle="background-color: #326CA6;padding:3px 8px;font-size:16px;margin-right:8px;"><#t/>
        Due ${dueDateString?html}<#t/>
    </@a><#t/>
</#macro><#t/>

<#--Must be repeated as HTML4 table styles can override outer styles (so has to be on every table to affect children)-->
<#assign defaultTextStyles = "font-family: Arial, Helvetica, sans-serif; font-size: 13px; color: #505050;" />

<@layout contentStyle="padding-right: 56px; ${defaultTextStyles}">
    <#list segmentDataList as segmentData><#t/>
        <#assign review = segmentData.review /><#t/>
        <table width="100%" style="${defaultTextStyles}">
            <tbody>
                <tr>
                    <td width="56" valign="top">
                    <#if segmentData.actioner??><#t/>
                        <@a href="${siteurl}/${navBuilder.user(segmentData.actioner)}">
                            <@img src="${avatarTypeInfo.getFullAvatarUrl(segmentData.actioner, 48)}" height="48" width="48"/>
                        </@a>
                    <#else>
                        <@a href="${siteurl}/${navBuilder.review(review)}" title="${review.permaId?html}">
                            <@reviewIcon/>
                        </@a>
                    </#if><#t/>
                    </td>
                    <td>
                        <@infoGroup margin="2px 0 0">
                            <#if segmentData.actioner??><#t/>
                                <@a href="${siteurl}/${navBuilder.user(segmentData.actioner)}">${segmentData.actioner.displayName?html}</@a>
                                sent you a review reminder
                            <#else>
                                This is an automated review reminder
                            </#if><#t/>
                        </@infoGroup>
                        <@infoGroup margin="8px 0 0" extraStyle="font-size:16px;">
                            <#if segmentData.actioner??><#t/>
                                <@reviewIcon size="16" extraAttrs='align="absmiddle"' />
                            </#if><#t/>
                            <@reviewLink review=review color="" />
                            <#if review.name?has_content>
                                &ndash; ${freemarkerUtil.formatWikiText(review.name!"_no name_", review)}
                            </#if><#t/>
                        </@infoGroup>

                        <#if segmentData.message?has_content>
                            <@mainSection padding="8px" margin="28px 0">
                                ${freemarkerUtil.newlinesToBrs(segmentData.message?html)}
                            </@mainSection>
                        </#if>

                        <p>
                            <#if segmentData.dueDateString??><#t/>
                                <@dueDateBlock review=review dueDateString=segmentData.dueDateString/><#t/>
                            </#if><#t/>
                            <#if segmentData.recipientReviewer><#t/>
                                <#if segmentData.hasCompleted><#t/>
                                    You are <b style="color: #393;">finished</b>!<#t/>
                                <#elseif segmentData.percentCompleted == 100><#t/>
                                    You need to Complete this review
                                <#else>
                                    You are <b style="color: #C00;">${segmentData.percentCompleted}%</b> complete<#t/>
                                </#if><#t/>
                            </#if><#t/>
                        </p>
                    </td>
                </tr>
            </tbody>
        </table>
    </#list><#t/>
</@layout>
