[#ftl]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" --]
[#-- @ftlvariable name="participant" type="com.cenqua.crucible.model.ReviewParticipant"--]
[#include "../../shared/util.ftl"/]
[#macro participantRow participant role]
<tr>
    <td width="32">
        [@a href="${siteurl}/${navBuilder.user(participant.user)}"]
            [@img src="${avatarTypeInfo.getFullAvatarUrl(participant.user, 32)}" height="32" width="32"/]
        [/@a]
    </td>
    <td style="padding-right: 30px;">
        [@a href="${siteurl}/${navBuilder.user(participant.user)}"]${participant.user.displayName?html}[/@a]
    </td>
    <td>
        ${role?html}
        [#if participant.isReviewer() && participant.isAllComplete()] <span style="color: #666; font-style: italic;">(complete)</span>[/#if]
    </td>
</tr>
[/#macro]
