[#ftl]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--]
[#include "../../shared/util.ftl"/]
[#macro reviewIcon size="40" extraAttrs=''][#t/]
    [@img src="${siteurl}/${staticPath}/2static/images/email/single_crucible_${size}.png" height="${size}" width="${size}" title="Review" alt="Review" extraAttrs="${extraAttrs}" /][#t/]
[/#macro][#t/]

[#macro reviewLink review color='#326CA6'][#t/]
    [@a color="${color}" href="${siteurl}/${navBuilder.review(review)}" title="${review.permaId?html}" extraStyle="font-size: 16px; font-weight: bold;"][#t/]
        ${review.permaId?html}[#t/]
    [/@a][#t/]
[/#macro][#t/]

[#macro reviewHeader review]
<table>
    <tr>
        <td rowspan="2" style="vertical-align:top; padding-right: 8px; text-align: center; width: 56px;">
            [@reviewIcon/]
        </td>
        <td>
            <span style="color: #333">
                ${freemarkerUtil.formatWikiText(review.name!"_no name_", review)}
            </span>
        </td>
    </tr>
    <tr>
        <td>
            [@reviewLink review=review/]
        </td>
    </tr>
</table>
[/#macro]
