[#ftl]
[#-- @ftlvariable name="mention" type="com.cenqua.crucible.notification.MentionUserInReviewDescriptionNotificationEvent" --]
[#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --]
[#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" --]

[#include "review-header.ftl"]
[#assign linkStyle="color: #326CA6; text-decoration: none; font-size: 16px; font-weight: bold;"/]

[#macro mentionTitle message link]
<table>
    <tr>
        <td rowspan="2" style="vertical-align:top; padding-right: 8px; text-align: center; width: 56px;">
            [#if mention.actioner?has_content]
                [@a href="${siteurl}/${navBuilder.user(mention.actioner)}"]
                    [@img src="${avatarTypeInfo.getFullAvatarUrl(mention.actioner, 40)}" height="40" width="40"/]
                [/@a]
            [/#if]
        </td>
        <td style="padding-right: 30px;">
            [#if mention.actioner?has_content]
                [@a href="${siteurl}/${navBuilder.user(mention.actioner)}"]${mention.actioner.displayName}[/@a]
            [/#if]
            <span style="color: #333">
                [@message/]
            </span>
        </td>
    </tr>
    <tr>
        <td>
            [#-- use style="${linkStyle}" in all links in thise macro --]
            [@link/]
        </td>
    </tr>
</table>
[/#macro]

[#macro standardMentionFooter]
<table width="100%">
    <tr>
        <td style="color: #666; padding-top: 10px">
            <div style="font-size: 12px;">
                <strong>Hint:</strong> You can mention somebody in ${mention.productName} by typing @ and then their name.
            </div>
        </td>
    </tr>
    <tr>
        <td style="color: #666; padding-top: 5px">
            <div style="font-size: 11px; line-height: 14px">
            If you are having trouble accessing the link, please copy and paste the URL below into your browser:<br/>
            <a style="text-decoration: none; color: #3C78B5" href="${mention.objectUrl}">${mention.objectUrl}</a>
            </div>
        </td>
    </tr>
</table>
[/#macro]