<#ftl>
<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"-->
<#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" -->
<#-- @ftlvariable name="notificationEvent" type="com.cenqua.crucible.notification.BaseCsCommentNotificationEvent"-->
<#-- @ftlvariable name="siteurl" type="java.lang.String" -->
<#include "crucible-layout.ftl"/>
<#include "comment-render-macro.ftl"/>
<@layout changeset=notificationEvent.changeSet repcfg=notificationEvent.repConfig>
<#-- todo user -->
<#if notificationEvent.comment?has_content>
    <#assign comment = notificationEvent.comment/>
    <#assign reply = comment.replyToComment!''/>
    <#assign depth = 0/>
    <#if reply?has_content>
        <#assign message = freemarkerUtil.formatWikiText(reply.message, reply.repository)/>
        <#assign permalink = siteurl + "/" + navBuilder.changesetComment(reply)/>
        <@commentRenderer author=reply.user message=message isNew=false isDefect=false depth=depth permalink=permalink/>
        <#assign depth = 1/>
    </#if>

    <#assign isDefect = notificationEvent.comment.isDefectRaised()/>
    <#assign message = freemarkerUtil.formatWikiText(comment.message, comment.repository)/>
    <#assign permalink = siteurl + "/" + navBuilder.changesetComment(comment)/>
    <@commentRenderer author=comment.user message=message isNew=true isDefect=isDefect depth=depth permalink=permalink/>
<#else>
    <@mainSection>
        Comment was deleted
    </@mainSection>
</#if>
</@layout>
