[#ftl]
[#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review" --]
[#-- @ftlvariable name="changeset" type="com.cenqua.fisheye.rep.ChangeSet" --]
[#-- @ftlvariable name="share" type="com.cenqua.crucible.notification.batch.creators.ShareContentBatchCreator.Share" --]
[#-- @ftlvariable name="siteurl" type="java.lang.String" --]
[#-- @ftlvariable name="staticPath" type="java.lang.String" --]
[#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--]
[#include "../../shared/util.ftl"/]
[#include "../../shared/html/changeset-header.ftl"/]
[#include "review-header.ftl"/]
[#include "review-summary.ftl"/]
[#include "share-header.ftl"/]
[#include "share-footer.ftl"/]
[#macro layout review='' changeset='' repcfg='' share='' contentStyle="margin: 10px 0 0 70px;" header='' footer='']
<html>
<head>
    <meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
    <meta name="viewport" content="width=device-width" />
</head>
<body>
    <table style="background-color: #F0F0F0; border: solid 1px #F0F0F0; color: #505050; font-size: 13px;" cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td align="center" style="padding: 20px">
                <table width="750" cellspacing="0" cellpadding="0">
                    <tr>
                        <td style="background-color: #036; color: #FFF;" align="left" width="750">
                            [@a href="${siteurl}/cru"]
                                [@img src="${siteurl}/${staticPath}/2static/images/email/crucible-header-v2.png" height="40px" width="155px" title="Crucible" alt="Crucible"/]
                            [/@a]
                        </td>
                    </tr>
                    <tr>
                        <td style="background-color: #FFF; border: 1px solid #BBB; padding: 20px; text-align: left;">
                            [#if review?has_content]
                                [@reviewHeader review=review/]
                            [/#if]
                            [#if changeset?has_content]
                                [@changesetHeader cs=changeset repcfg=repcfg showFiles=false user=freemarkerUtil.getAuthorForChangeset(changeset)/]
                            [/#if]
                            [#if share?has_content]
                                [@shareHeader share=share/]
                            [/#if]
                            [#if header?is_directive][@header/][/#if]

                            <!--Conditional comment that targets Outlook 2007 and higher-->
                            <!--[if gte mso 9]><br /><![endif]-->
                            <div style="${contentStyle}">
                                [#nested/]

                                [#if review?has_content]
                                    [@reviewSummary review=review/]
                                [/#if]
                                [#if share?has_content]
                                    [@shareFooter share=share/]
                                [/#if]
                                [#if footer?is_directive][@footer/][/#if]
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 11px; text-align: center; color: #666; padding-top: 5px">
                            Sent by [@a href="http://www.atlassian.com/crucible" color="#666"]Atlassian Crucible[/@a] ${freemarkerUtil.getAppVersion()?html}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>
[/#macro]
