<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"-->
<#-- @ftlvariable name="avatarTypeInfo" type="com.atlassian.fisheye.gravatar.AvatarTypeInfo" -->
<#-- @ftlvariable name="siteurl" type="java.lang.String" -->
<#-- @ftlvariable name="staticPath" type="java.lang.String" -->
<#-- @ftlvariable name="additionalNote" type="java.lang.String" -->
<#include "../../shared/util.ftl"/><#t/>
<#macro commentRenderer author message isNew isDefect depth permalink additionalNote=""><#t/>
<#assign leftMargin = depth * 25/><#t/>
<#assign commentWidth = 620 - (depth * 25) - 44 /><#t/>
<#assign commentBgColor>${freemarkerUtil.getCommentBgColor(isNew, isDefect)}</#assign>
<#assign commentBorder>${freemarkerUtil.getCommentBorder(isNew, isDefect)}</#assign>
<table style="background-color: ${commentBgColor};border: ${commentBorder};table-layout: fixed; margin-left: ${leftMargin}px; margin-top: 5px;" cellpadding="5" cellspacing="0" bgcolor="${commentBgColor}">
    <tr>
        <td style="vertical-align:top; width: 34px" width="34">
            <@img src="${avatarTypeInfo.getFullAvatarUrl(author, 32)}" height="32" width="32"/>
        </td>
        <td width="${commentWidth}">
            ${author.displayName?html}
        </td>
    </tr>
    <tr>
        <td style="vertical-align:top; text-align: center;">
            <@a href="${permalink}">
                <@img src="${siteurl}/${staticPath}/2static/images/permalink_light_16.png" height="16" width="16" alt="permalink" title="View this comment"/>
            </@a>
        </td>
        <td width="${commentWidth}">
            ${message}
        </td>
    </tr>
    <#if additionalNote?has_content>
        <tr>
            <td></td>
            <td width="${commentWidth}">
                ${additionalNote}
            </td>
        </tr>
    </#if>
</table>
<!--Conditional comment that targets Outlook 2007 and higher-->
<!--[if gte mso 9]><br /><![endif]-->
</#macro>
