<#-- @ftlvariable name="freemarkerUtil" type="com.cenqua.crucible.util.FreemarkerUtil"--><#t/>
<#-- @ftlvariable name="navBuilder" type="com.atlassian.fisheye.web.NavBuilder.static" --><#t/>
<#-- @ftlvariable name="siteurl" type="java.lang.String" --><#t/>
<#-- @ftlvariable name="formatter" type="com.cenqua.crucible.util.EmailAllCommentsFormatter"--><#t/>
<#-- @ftlvariable name="review" type="com.cenqua.crucible.model.Review"--><#t/>
<#-- @ftlvariable name="rootComments" type="java.util.Set<com.cenqua.fisheye.util.Pair<com.cenqua.crucible.model.FileRevisionExtraInfo, com.cenqua.crucible.model.Comment>>"--><#t/>
<#-- @ftlvariable name="newComments" type="java.util.Set<com.cenqua.crucible.model.Comment>"--><#t/>
<#-- @ftlvariable name="commentNotes" type="java.util.Map<java.lang.String, com.cenqua.crucible.util.HtmlAndTextPair>"--><#t/>
<#-- @ftlvariable name="comment" type="com.cenqua.crucible.model.Comment"--><#t/>
<#-- @ftlvariable name="fileAndCommentPair" type="com.cenqua.fisheye.util.Pair<com.cenqua.crucible.model.FileRevisionExtraInfo, com.cenqua.crucible.model.Comment>"--><#t/>
<#-- @ftlvariable name="prevFile" type="com.cenqua.crucible.model.FileRevisionExtraInfo"--><#t/>
<#-- @ftlvariable name="note" type="com.cenqua.crucible.util.HtmlAndTextPair"--><#t/>
<#-- @ftlvariable name="additionalNote" type="java.lang.String"--><#t/>
<#t/>
<#include "../../shared/util.ftl"/><#t/>
<#include "comment-render-macro.ftl"/><#t/>
<#macro commentListHtml review rootComments newComments=[] commentNotes={}><#t/>
    <#assign firstGeneralComment = true/><#t/>
    <#list rootComments as fileAndCommentPair ><#t/>
        <#assign comment = fileAndCommentPair.second/><#t/>
        <#if !comment.isDraft() && !comment.isDeleted()><#t/>
            <#if !review.isSnippet()>
                <#assign marginTop = "15px"/><#t/>
                <#if fileAndCommentPair_index == 0>
                    <#assign marginTop = "0px"/><#t/>
                </#if>
                <#if !(fileAndCommentPair.first??) && firstGeneralComment>
                    <#assign firstGeneralComment = false/><#t/>
                <div style="margin-top: ${marginTop};"><@a href="${siteurl}/${navBuilder.reviewGeneralComments(comment.review)}">${"General Comments"?html}</@a></div>
                </#if>
                <#if fileAndCommentPair.first?? && (!prevFile?? || fileAndCommentPair.first != prevFile)><#t/>
                    <#assign prevFile = fileAndCommentPair.first/>
                    <#assign fileName = fileAndCommentPair.first.fePath.name/>
                <div style="margin-top: ${marginTop};"><@a href="${siteurl}/${navBuilder.reviewFile(fileAndCommentPair.first)}">${fileName?html}</@a></div>
                </#if><#t/>
            </#if>
            <#assign isNew = newComments?seq_contains(comment)/><#t/>
            <#assign isDefect = comment.isDefectRaised()/><#t/>
            <#assign message = freemarkerUtil.formatWikiText(comment.message, comment.review)/><#t/>
            <#assign permalink = siteurl + "/" + navBuilder.reviewComment(comment)/><#t/>
            <#assign additionalNote=""/>
            <#if commentNotes?? && commentNotes?keys?seq_contains(comment.permaId)>
                <#assign note = commentNotes[comment.permaId] />
                <#assign additionalNote=(note.html!(note.plainText?html))/>
            </#if>
            <@commentRenderer author=comment.user message=message isNew=isNew isDefect=isDefect depth=0 permalink=permalink additionalNote=additionalNote/>
            <#list comment.commentsAndReplies as reply><#t/>
                <#if reply.reply && !reply.isDraft() && !reply.isDeleted()><#t/>
                    <#assign depth = formatter.getIndentationDepth(reply)/><#t/>
                    <#assign isNew = newComments?seq_contains(reply)/><#t/>
                    <#assign isDefect = reply.isDefectRaised()/><#t/>
                    <#assign message = freemarkerUtil.formatWikiText(reply.message, reply.review)/><#t/>
                    <#assign permalink = siteurl + "/" + navBuilder.reviewComment(reply)/>
                    <#assign additionalNote=""/>
                    <#if commentNotes?? && commentNotes?keys?seq_contains(reply.permaId)>
                        <#assign note = commentNotes[reply.permaId] />
                        <#assign additionalNote=(note.html!(note.plainText?html))/>
                    </#if>
                    <@commentRenderer author=reply.user message=message isNew=isNew isDefect=isDefect depth=depth permalink=permalink additionalNote=additionalNote/>
                </#if><#t/>
            </#list><#t/>
        </#if><#t/>
    </#list><#t/>
</#macro>
