create table cru_builtin_group (cru_builtin_group_id int not null, cru_builtin_group_name nvarchar(255) not null unique, primary key (cru_builtin_group_id));
create table cru_builtin_group_user (cru_builtin_group_id int not null, cru_user_id int not null, primary key (cru_builtin_group_id, cru_user_id));
create table cru_commit_notification (cru_commit_notification_id numeric(19,0) not null, cru_repository_name nvarchar(100) null unique, cru_last_checked numeric(19,0) null, cru_changeset_idx_serial numeric(19,0) null, cru_cache_serial_last_rev numeric(19,0) null, primary key (cru_commit_notification_id));
create table cru_login_cookie (cru_login_cookie_id numeric(19,0) not null, cru_user_id int null, cru_rnd nvarchar(100) null, cru_create_date numeric(19,0) null, cru_type int null, cru_url nvarchar(1650) null, cru_recursive_url tinyint null, primary key (cru_login_cookie_id));
create table cru_watch (cru_watch_id numeric(19,0) not null, cru_user_id int null, cru_repository_name nvarchar(100) null, cru_path nvarchar(1650) null, cru_constraint nvarchar(1650) null, cru_last_checked numeric(19,0) null, cru_last_revision_path nvarchar(1650) null, cru_last_revision_rev nvarchar(100) null, cru_csn_last_revision numeric(19,0) null, cru_watch_key nvarchar(64) null unique, primary key (cru_watch_id));
create index idx_builtin_group_name on cru_builtin_group (cru_builtin_group_name);
alter table cru_builtin_group_user add constraint FK63C7EA20E86435BB foreign key (cru_builtin_group_id) references cru_builtin_group;
alter table cru_builtin_group_user add constraint FK63C7EA20A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_commitnotif_rep on cru_commit_notification (cru_repository_name);
alter table cru_login_cookie add constraint FKD7454DB3A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_cru_type on cru_login_cookie (cru_type);
alter table cru_watch add constraint FK6ECD2536A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_watch_repository_name on cru_watch (cru_repository_name);
create index idx_watch_key on cru_watch (cru_watch_key);
# Please note there is no need to bump up cru_version in this script anymore,
# BumpDbVersionUpgradeTask would take care of this.
