create table cru_builtin_group (cru_builtin_group_id int4 not null, cru_builtin_group_name varchar(255) not null unique, primary key (cru_builtin_group_id));
create table cru_builtin_group_user (cru_builtin_group_id int4 not null, cru_user_id int4 not null, primary key (cru_builtin_group_id, cru_user_id));
create table cru_commit_notification (cru_commit_notification_id int8 not null, cru_repository_name varchar(100) unique, cru_last_checked int8, cru_changeset_idx_serial int8, cru_cache_serial_last_rev int8, primary key (cru_commit_notification_id));
create table cru_login_cookie (cru_login_cookie_id int8 not null, cru_user_id int4, cru_rnd varchar(100), cru_create_date int8, cru_type int4, cru_url varchar(1650), cru_recursive_url bool, primary key (cru_login_cookie_id));
create table cru_watch (cru_watch_id int8 not null, cru_user_id int4, cru_repository_name varchar(100), cru_path varchar(1650), cru_constraint varchar(1650), cru_last_checked int8, cru_last_revision_path varchar(1650), cru_last_revision_rev varchar(100), cru_csn_last_revision int8, cru_watch_key varchar(64) unique, primary key (cru_watch_id));
create index idx_builtin_group_name on cru_builtin_group (cru_builtin_group_name);
alter table cru_builtin_group_user add constraint FK63C7EA20E86435BB foreign key (cru_builtin_group_id) references cru_builtin_group;
alter table cru_builtin_group_user add constraint FK63C7EA20A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_commitnotif_rep on cru_commit_notification (cru_repository_name);
alter table cru_login_cookie add constraint FKD7454DB3A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_cru_type on cru_login_cookie (cru_type);
alter table cru_watch add constraint FK6ECD2536A697BC70 foreign key (cru_user_id) references cru_user;
create index idx_watch_repository_name on cru_watch (cru_repository_name);
create index idx_watch_key on cru_watch (cru_watch_key);
# Please note there is no need to bump up cru_version in this script anymore,
# BumpDbVersionUpgradeTask would take care of this.
