alter table cru_changeset_comment drop constraint FK1C588BB9C50DAE44;
alter table cru_comment drop constraint FKE5A1D106C50DAE44;
alter table cru_comment_read_status drop constraint FKC3617502A88A4012;
alter table cru_notification drop constraint FK1F9536A4B0A0252A;
alter table cru_proj_allowed_reviewer drop constraint FK1E8211C5C50DAE44;
alter table cru_proj_default_reviewer drop constraint FK3F4F594CC50DAE44;
alter table cru_project drop constraint FK9A8C2DC0E2A633FC;
alter table cru_recipient drop constraint FK8E6F4700A88A4012;
alter table cru_recipient drop constraint FK8E6F47009F44EBB8;
alter table cru_review drop constraint FK6288A3D1B214061;
alter table cru_review_participant drop constraint FK54EBFC5A88A4012;
alter table cru_state_change drop constraint FKF37CE4D7A88A4012;
alter table cru_upload_item drop constraint FK70E1F5B8A88A4012;
alter table cru_user_app_link drop constraint FKCFD67EB3A88A4012;

alter table cru_user add column cru_email varchar(255);
alter table cru_user add column cru_passwordhash varchar(255);
alter table cru_user add column cru_authtype int2;
alter table cru_user add column cru_displayname varchar(255);
alter table cru_user add column cru_fisheye_enabled bool;
alter table cru_user add column cru_crucible_enabled bool;
alter table cru_user add column cru_passwordreset_srnd varchar(255);
alter table cru_user add column cru_passwordresettimestamp int8;
alter table cru_user add column cru_failedlogincount int8;
alter table cru_user add column cru_timezone varchar(255);

create table cru_user_profile (cru_user_id int4 not null, cru_tabwidth int4, cru_cookieprefs varchar(4096), cru_watchmode int4, cru_emailformat int4, cru_changesetsperpage int4, cru_maxfilesperchangeset int4, cru_ideconnectorport int4, cru_enableide bool, cru_context int4, cru_upload_type varchar(255), cru_upload_method varchar(255), cru_upload_charset varchar(255), cru_auto_mark_files bool, cru_dont_send_me_my_notes bool not null, cru_state_change_email_note int4 not null, cru_comment_email_note int4 not null, cru_reply_email_note int4 not null, cru_general_email_note int4 not null, cru_complete_email_note int4 not null, cru_uncomplete_email_note int4 not null, cru_uncomplete_on_defect bool not null, cru_uncomplete_on_rev_added bool not null, primary key (cru_user_id));
insert into cru_user_profile (cru_user_id, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) select cru_user_id, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added from cru_user;

alter table cru_user drop column cru_dont_send_me_my_notes;
alter table cru_user drop column cru_state_change_email_note;
alter table cru_user drop column cru_comment_email_note;
alter table cru_user drop column cru_reply_email_note;
alter table cru_user drop column cru_general_email_note;
alter table cru_user drop column cru_complete_email_note;
alter table cru_user drop column cru_uncomplete_email_note;
alter table cru_user drop column cru_uncomplete_on_defect;
alter table cru_user drop column cru_uncomplete_on_rev_added;

alter table cru_changeset_comment add constraint FK1C588BB9A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_comment add constraint FKE5A1D106A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_comment_read_status add constraint FKC36175028A144E3E foreign key (cru_user) references cru_user;
alter table cru_notification add constraint FK1F9536A4922A3356 foreign key (cru_actioner) references cru_user;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_proj_default_reviewer add constraint FK3F4F594CA697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_project add constraint FK9A8C2DC0C4304228 foreign key (cru_default_moderator) references cru_user;
alter table cru_recipient add constraint FK8E6F47008A144E3E foreign key (cru_user) references cru_user;
alter table cru_recipient add constraint FK8E6F4700C49FFAE2 foreign key (cru_notification_id) references cru_notification;
alter table cru_review add constraint FK6288A3D1ECAB4E8D foreign key (cru_creator) references cru_user;
alter table cru_review_participant add constraint FK54EBFC58A144E3E foreign key (cru_user) references cru_user;
alter table cru_state_change add constraint FKF37CE4D78A144E3E foreign key (cru_user) references cru_user;
alter table cru_upload_item add constraint FK70E1F5B88A144E3E foreign key (cru_user) references cru_user;
alter table cru_user_app_link add constraint FKCFD67EB38A144E3E foreign key (cru_user) references cru_user;
alter table cru_user_profile add constraint FK4498CEEEA697BC70 foreign key (cru_user_id) references cru_user;

UPDATE cru_version SET cru_version = 74 WHERE cru_version_id = 1;