alter table cru_revision add column cru_added bool;
alter table cru_revision add column cru_modified bool;
alter table cru_revision add column cru_moved bool;
alter table cru_revision add column cru_copied bool;

drop index "fr_author_idx";
drop index "fr_name_idx";
drop index "fr_rev_idx";
drop index "fr_source_idx";

UPDATE cru_revision SET cru_added = (cru_value = 'true') FROM (SELECT cru_revision_id, cru_value FROM cru_fr_detail WHERE cru_name = 'added') AS t WHERE cru_revision.cru_revision_id = t.cru_revision_id;
UPDATE cru_revision SET cru_modified = (cru_value = 'true') FROM (SELECT cru_revision_id, cru_value FROM cru_fr_detail WHERE cru_name = 'modified') AS t WHERE cru_revision.cru_revision_id = t.cru_revision_id;
UPDATE cru_revision SET cru_moved = (cru_value = 'true') FROM (SELECT cru_revision_id, cru_value FROM cru_fr_detail WHERE cru_name = 'moved') AS t WHERE cru_revision.cru_revision_id = t.cru_revision_id;
UPDATE cru_revision SET cru_copied = (cru_value = 'true') FROM (SELECT cru_revision_id, cru_value FROM cru_fr_detail WHERE cru_name = 'copied') AS t WHERE cru_revision.cru_revision_id = t.cru_revision_id;

create index "fr_author_idx" on cru_revision(cru_author_name);
create index "fr_name_idx" on cru_revision(cru_revision_display_name);
create index "fr_rev_idx" on cru_revision(cru_revision);
create index "fr_source_idx" on cru_revision(cru_source_name);

DELETE FROM cru_fr_detail WHERE cru_name IN ('added', 'modified', 'moved', 'copied');

UPDATE cru_version SET cru_version = 53 WHERE cru_version_id = 1;
