
# this table may have already been upgraded in upgrade_78.sql. we need to use pl/sql to check if the type of the column is a clob or a long - only upgrade on long
!proc
declare
  dataType varchar(20);
begin
  select LOWER(data_type) into dataType
  from user_tab_columns
  where LOWER(TABLE_NAME) = 'cru_notification' and LOWER(COLUMN_NAME) = 'cru_object_url';
  if dataType = 'long' then
    execute immediate 'alter table cru_notification drop constraint FK1F9536A42C3DCA3D';
    execute immediate 'alter table cru_notification drop constraint FK1F9536A4922A3356';
    execute immediate 'alter table cru_recipient drop constraint FK8E6F4700C49FFAE2';

    execute immediate 'drop index notifiaction_review_idx';
    execute immediate 'drop index notification_ref2_idx';
    execute immediate 'drop index notification_ref1_idx';

    execute immediate 'create table cru_notification2 (cru_notification_id number(10,0) not null, cru_note_type varchar2(255 char) not null, cru_create_date number(19,0), cru_actioner number(10,0), cru_note clob, cru_review number(10,0), cru_ref1 number(10,0), cru_ref2 number(10,0), cru_object_url clob, cru_object_name varchar2(255 char), cru_object_id varchar2(255 char), cru_object_repository varchar2(255 char), primary key (cru_notification_id))';

    execute immediate 'insert into cru_notification2 (
             cru_notification_id, cru_note_type, cru_create_date, cru_actioner, cru_note, cru_review, cru_ref1, cru_ref2, cru_object_url,         cru_object_name, cru_object_id, cru_object_repository)
      select cru_notification_id, cru_note_type, cru_create_date, cru_actioner, cru_note, cru_review, cru_ref1, cru_ref2, to_lob(cru_object_url), cru_object_name, cru_object_id, cru_object_repository
      from cru_notification';

    execute immediate 'drop table cru_notification';

    execute immediate 'alter table
        cru_notification2
      rename to
        cru_notification';

    execute immediate 'create index notifiaction_review_idx on cru_notification (cru_review)';
    execute immediate 'create index notification_ref2_idx on cru_notification (cru_ref2)';
    execute immediate 'create index notification_ref1_idx on cru_notification (cru_ref1)';

    execute immediate 'alter table cru_notification add constraint FK1F9536A42C3DCA3D foreign key (cru_review) references cru_review';
    execute immediate 'alter table cru_notification add constraint FK1F9536A4922A3356 foreign key (cru_actioner) references cru_user';

    execute immediate 'alter table cru_recipient add constraint FK8E6F4700C49FFAE2 foreign key (cru_notification_id) references cru_notification';
  end if;
end;
!endproc

alter table cru_user_profile drop constraint FK4498CEEEA697BC70;

create table cru_user_profile2 (cru_user_id number(10,0) not null, cru_tabwidth number(10,0), cru_cookieprefs clob, cru_watchmode number(10,0), cru_emailformat number(10,0), cru_changesetsperpage number(10,0), cru_maxfilesperchangeset number(10,0), cru_ideconnectorport number(10,0), cru_enableide number(1,0), cru_context number(10,0), cru_upload_type varchar2(255 char), cru_upload_method varchar2(255 char), cru_upload_charset varchar2(255 char), cru_auto_mark_files number(1,0), cru_dont_send_me_my_notes number(1,0) not null, cru_state_change_email_note number(10,0) not null, cru_comment_email_note number(10,0) not null, cru_reply_email_note number(10,0) not null, cru_general_email_note number(10,0) not null, cru_complete_email_note number(10,0) not null, cru_uncomplete_email_note number(10,0) not null, cru_uncomplete_on_defect number(1,0) not null, cru_uncomplete_on_rev_added number(1,0) not null, primary key (cru_user_id));

insert into cru_user_profile2 (cru_user_id, cru_tabwidth, cru_cookieprefs,         cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added)
                        select cru_user_id, cru_tabwidth, TO_LOB(cru_cookieprefs), cru_watchmode, cru_emailformat, cru_changesetsperpage, cru_maxfilesperchangeset, cru_ideconnectorport, cru_enableide, cru_context, cru_upload_type, cru_upload_method, cru_upload_charset, cru_auto_mark_files, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added from cru_user_profile;

drop table cru_user_profile;

alter table
  cru_user_profile2
rename to
  cru_user_profile;

alter table cru_user_profile add constraint FK4498CEEEA697BC70 foreign key (cru_user_id) references cru_user;


UPDATE cru_version SET cru_version = 81 WHERE cru_version_id = 1;