alter table cru_changeset_comment drop constraint FK1C588BB9C50DAE44;
alter table cru_comment drop constraint FKE5A1D106C50DAE44;
alter table cru_comment_read_status drop constraint FKC3617502A88A4012;
alter table cru_notification drop constraint FK1F9536A4B0A0252A;
alter table cru_proj_allowed_reviewer drop constraint FK1E8211C5C50DAE44;
alter table cru_proj_default_reviewer drop constraint FK3F4F594CC50DAE44;
alter table cru_project drop constraint FK9A8C2DC0E2A633FC;
alter table cru_recipient drop constraint FK8E6F4700A88A4012;
alter table cru_recipient drop constraint FK8E6F47009F44EBB8;
alter table cru_review drop constraint FK6288A3D1B214061;
alter table cru_review_participant drop constraint FK54EBFC5A88A4012;
alter table cru_state_change drop constraint FKF37CE4D7A88A4012;
alter table cru_upload_item drop constraint FK70E1F5B8A88A4012;
alter table cru_user_app_link drop constraint FKCFD67EB3A88A4012;

alter table cru_user add cru_email varchar2(255 char);
alter table cru_user add cru_passwordhash varchar2(255 char);
alter table cru_user add cru_authtype number(5,0);
alter table cru_user add cru_displayname varchar2(255 char);
alter table cru_user add cru_fisheye_enabled number(1,0);
alter table cru_user add cru_crucible_enabled number(1,0);
alter table cru_user add cru_passwordreset_srnd varchar2(255 char);
alter table cru_user add cru_passwordresettimestamp number(19,0);
alter table cru_user add cru_failedlogincount number(19,0);
alter table cru_user add cru_timezone varchar2(255 char);

create table cru_user_profile (cru_user_id number(10,0) not null, cru_tabwidth number(10,0), cru_cookieprefs long, cru_watchmode number(10,0), cru_emailformat number(10,0), cru_changesetsperpage number(10,0), cru_maxfilesperchangeset number(10,0), cru_ideconnectorport number(10,0), cru_enableide number(1,0), cru_context number(10,0), cru_upload_type varchar2(255 char), cru_upload_method varchar2(255 char), cru_upload_charset varchar2(255 char), cru_auto_mark_files number(1,0), cru_dont_send_me_my_notes number(1,0) not null, cru_state_change_email_note number(10,0) not null, cru_comment_email_note number(10,0) not null, cru_reply_email_note number(10,0) not null, cru_general_email_note number(10,0) not null, cru_complete_email_note number(10,0) not null, cru_uncomplete_email_note number(10,0) not null, cru_uncomplete_on_defect number(1,0) not null, cru_uncomplete_on_rev_added number(1,0) not null, primary key (cru_user_id));
insert into cru_user_profile (cru_user_id, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added) select cru_user_id, cru_dont_send_me_my_notes, cru_state_change_email_note, cru_comment_email_note, cru_reply_email_note, cru_general_email_note, cru_complete_email_note, cru_uncomplete_email_note, cru_uncomplete_on_defect, cru_uncomplete_on_rev_added from cru_user;

alter table cru_user drop column cru_dont_send_me_my_notes;
alter table cru_user drop column cru_state_change_email_note;
alter table cru_user drop column cru_comment_email_note;
alter table cru_user drop column cru_reply_email_note;
alter table cru_user drop column cru_general_email_note;
alter table cru_user drop column cru_complete_email_note;
alter table cru_user drop column cru_uncomplete_email_note;
alter table cru_user drop column cru_uncomplete_on_defect;
alter table cru_user drop column cru_uncomplete_on_rev_added;

alter table cru_changeset_comment add constraint FK1C588BB9A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_comment add constraint FKE5A1D106A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_comment_read_status add constraint FKC36175028A144E3E foreign key (cru_user) references cru_user;
alter table cru_notification add constraint FK1F9536A4922A3356 foreign key (cru_actioner) references cru_user;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5A697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_proj_default_reviewer add constraint FK3F4F594CA697BC70 foreign key (cru_user_id) references cru_user;
alter table cru_project add constraint FK9A8C2DC0C4304228 foreign key (cru_default_moderator) references cru_user;
alter table cru_recipient add constraint FK8E6F47008A144E3E foreign key (cru_user) references cru_user;
alter table cru_recipient add constraint FK8E6F4700C49FFAE2 foreign key (cru_notification_id) references cru_notification;
alter table cru_review add constraint FK6288A3D1ECAB4E8D foreign key (cru_creator) references cru_user;
alter table cru_review_participant add constraint FK54EBFC58A144E3E foreign key (cru_user) references cru_user;
alter table cru_state_change add constraint FKF37CE4D78A144E3E foreign key (cru_user) references cru_user;
alter table cru_upload_item add constraint FK70E1F5B88A144E3E foreign key (cru_user) references cru_user;
alter table cru_user_app_link add constraint FKCFD67EB38A144E3E foreign key (cru_user) references cru_user;
alter table cru_user_profile add constraint FK4498CEEEA697BC70 foreign key (cru_user_id) references cru_user;

UPDATE cru_version SET cru_version = 74 WHERE cru_version_id = 1;
