create table cru_builtin_group (cru_builtin_group_id integer not null, cru_builtin_group_name varchar(255) not null unique, primary key (cru_builtin_group_id)) ENGINE=InnoDB;
create table cru_builtin_group_user (cru_builtin_group_id integer not null, cru_user_id integer not null, primary key (cru_builtin_group_id, cru_user_id)) ENGINE=InnoDB;
create table cru_commit_notification (cru_commit_notification_id bigint not null, cru_repository_name varchar(100) unique, cru_last_checked bigint, cru_changeset_idx_serial bigint, cru_cache_serial_last_rev bigint, primary key (cru_commit_notification_id)) ENGINE=InnoDB;
create table cru_login_cookie (cru_login_cookie_id bigint not null, cru_user_id integer, cru_rnd varchar(100), cru_create_date bigint, cru_type integer, cru_url varchar(1650), cru_recursive_url bit, primary key (cru_login_cookie_id)) ENGINE=InnoDB;
create table cru_watch (cru_watch_id bigint not null, cru_user_id integer, cru_repository_name varchar(100), cru_path varchar(1650), cru_constraint varchar(1650), cru_last_checked bigint, cru_last_revision_path varchar(1650), cru_last_revision_rev varchar(100), cru_csn_last_revision bigint, cru_watch_key varchar(64) unique, primary key (cru_watch_id)) ENGINE=InnoDB;
create index idx_builtin_group_name on cru_builtin_group (cru_builtin_group_name);
alter table cru_builtin_group_user add index FK63C7EA20E86435BB (cru_builtin_group_id), add constraint FK63C7EA20E86435BB foreign key (cru_builtin_group_id) references cru_builtin_group (cru_builtin_group_id);
alter table cru_builtin_group_user add index FK63C7EA20A697BC70 (cru_user_id), add constraint FK63C7EA20A697BC70 foreign key (cru_user_id) references cru_user (cru_user_id);
create index idx_commitnotif_rep on cru_commit_notification (cru_repository_name);
alter table cru_login_cookie add index FKD7454DB3A697BC70 (cru_user_id), add constraint FKD7454DB3A697BC70 foreign key (cru_user_id) references cru_user (cru_user_id);
create index idx_cru_type on cru_login_cookie (cru_type);
alter table cru_watch add index FK6ECD2536A697BC70 (cru_user_id), add constraint FK6ECD2536A697BC70 foreign key (cru_user_id) references cru_user (cru_user_id);
create index idx_watch_repository_name on cru_watch (cru_repository_name);
create index idx_watch_key on cru_watch (cru_watch_key);
# Please note there is no need to bump up cru_version in this script anymore,
# BumpDbVersionUpgradeTask would take care of this.
