#idempotent corrections to previous schema upgrade omissions and errors

#apply corrections of column types for 62->63 upgrade
alter table cru_base_star_model change column cru_text_key1 cru_text_key1 longtext;
alter table cru_base_star_model change column cru_text_key2 cru_text_key2 longtext;
alter table cru_comment change column cru_message cru_message longtext not null;
alter table cru_fr_detail change column cru_value cru_value longtext;
alter table cru_logitem change column cru_description cru_description longtext;
alter table cru_logitem change column cru_entity_string cru_entity_string longtext;
alter table cru_logitem change column cru_old_value cru_old_value longtext;
alter table cru_logitem change column cru_new_value cru_new_value longtext;
alter table cru_metric_definition change column cru_xml cru_xml longtext;
alter table cru_notification change column cru_note cru_note longtext;
alter table cru_project change column cru_default_objectives cru_default_objectives longtext;
alter table cru_review change column cru_description cru_description longtext;
alter table cru_review change column cru_summary cru_summary longtext;
alter table cru_upload_item change column cru_description cru_description longtext;

#undo 70->71 narrowing of column type
alter table cru_project change cru_proj_key cru_proj_key varchar(80) not null;
alter table cru_project change cru_name cru_name varchar(80) not null;

#clean up indexes
drop procedure if exists cru_cleanup_indexes;
!proc
create procedure cru_cleanup_indexes()
begin
    #recreate index which may have been wiped out in upgrade 66->67
    if((select count(*) as index_exists from information_schema.statistics where table_schema = database() and table_name = 'cru_stored_path' and index_name = 'cru_idx_stored_path') > 0) then
        drop index cru_idx_stored_path on cru_stored_path;
    end if;
    create index cru_idx_stored_path on cru_stored_path (cru_path(255));

    #drop foreign key index omitted from upgrade 70->71 (fk was dropped but not the index)
    if((select count(*) as index_exists from information_schema.statistics where table_schema = database() and table_name = 'cru_inline_comment_to_frx_rev' and index_name = 'FK25B4CCC5276E223A') > 0) then
        alter table cru_inline_comment_to_frx_rev drop index FK25B4CCC5276E223A;
    end if;

    #drop foreign key index omitted from upgrade 70->71 (fk was dropped but not the index)
    if((select count(*) as index_exists from information_schema.statistics where table_schema = database() and table_name = 'cru_inline_comment_to_frx_rev' and index_name = 'FK25B4CCC58DEFF736') > 0) then
        alter table cru_inline_comment_to_frx_rev drop index FK25B4CCC58DEFF736;
    end if;
end
!endproc
call cru_cleanup_indexes();
drop procedure cru_cleanup_indexes;

UPDATE cru_version SET cru_version = 72 WHERE cru_version_id = 1;