#mysql can barf on the following group by query if there isnt enough sort_buffer_size memory (i.e., < 64k). The default of 512k should be enough
set @cru_original_buffer_size = @@sort_buffer_size;
set session sort_buffer_size=512*1024;
#delete duplicate rows
delete from
    cru_base_star_model
where
    cru_item_type='atlassian-diff' and
    cru_star_id not in (
        select max_id from (
            select
                max(dup.cru_star_id) as "max_id"
            from
                cru_base_star_model as dup
            where
                dup.cru_item_type='atlassian-diff'
            group by
                dup.cru_string_key1,
                dup.cru_string_key2,
                dup.cru_string_key3,
                dup.cru_string_key4,
                dup.cru_string_key5,
                dup.cru_user_name)
        as t);

#restore the original value before continuing
set session sort_buffer_size=@cru_original_buffer_size;

#remove the REPO from the path
update cru_base_star_model set cru_string_key1 =
    right(cru_string_key1, char_length(substring(cru_string_key1, locate('/', cru_string_key1)+1)))
        where cru_item_type ='atlassian-diff';
update cru_base_star_model set cru_string_key3 =
    right(cru_string_key3, char_length(substring(cru_string_key3, locate('/', cru_string_key3)+1)))
        where cru_item_type ='atlassian-diff';

update cru_version set cru_version = 55 where cru_version_id = 1;