create table cwd_app_dir_group_mapping (id bigint not null, app_dir_mapping_id bigint not null, application_id bigint not null, directory_id bigint not null, group_name varchar(255) not null, primary key (id));
create table cwd_app_dir_mapping (id bigint not null, application_id bigint not null, directory_id bigint not null, allow_all char(255) not null, list_index integer, primary key (id));
create table cwd_app_dir_operation (app_dir_mapping_id bigint not null, operation_type varchar(32) not null, primary key (app_dir_mapping_id, operation_type));
create table cwd_application (id bigint not null, application_name varchar(255) not null, lower_application_name varchar(255) not null, created_date timestamp not null, updated_date timestamp not null, active char(255) not null, description varchar(255), application_type varchar(32) not null, credential varchar(255) not null, primary key (id));
create table cwd_application_address (application_id bigint not null, remote_address varchar(255) not null, primary key (application_id, remote_address));
create table cwd_application_alias (id bigint not null, application_id bigint not null, user_name varchar(255) not null, lower_user_name varchar(255) not null, alias_name varchar(255) not null, lower_alias_name varchar(255) not null, primary key (id));
create table cwd_application_attribute (application_id bigint not null, attribute_value varchar(4000), attribute_name varchar(255) not null, primary key (application_id, attribute_name));
create table cwd_directory (id bigint not null, directory_name varchar(255) not null, lower_directory_name varchar(255) not null, created_date timestamp not null, updated_date timestamp not null, active char(255) not null, description varchar(255), impl_class varchar(255) not null, lower_impl_class varchar(255) not null, directory_type varchar(32) not null, primary key (id));
create table cwd_directory_attribute (directory_id bigint not null, attribute_value varchar(4000), attribute_name varchar(255) not null, primary key (directory_id, attribute_name));
create table cwd_directory_operation (directory_id bigint not null, operation_type varchar(32) not null, primary key (directory_id, operation_type));
create table cwd_expirable_user_token (id bigint not null, token varchar(255) not null, user_name varchar(255), email_address varchar(255), expiry_date bigint not null, directory_id bigint not null, primary key (id));
create table cwd_granted_perm (id bigint not null, created_date timestamp not null, permission_id integer not null, group_mapping bigint, primary key (id));
create table cwd_group (id bigint not null, group_name varchar(255) not null, lower_group_name varchar(255) not null, active char(255) not null, is_local char(255) not null, created_date timestamp not null, updated_date timestamp not null, description varchar(255), group_type varchar(32) not null, directory_id bigint not null, primary key (id));
create table cwd_group_attribute (id bigint not null, group_id bigint not null, directory_id bigint not null, attribute_name varchar(255) not null, attribute_value varchar(255), attribute_lower_value varchar(255), primary key (id));
create table cwd_membership (id bigint not null, parent_id bigint, child_id bigint, membership_type varchar(32), group_type varchar(32) not null, parent_name varchar(255) not null, lower_parent_name varchar(255) not null, child_name varchar(255) not null, lower_child_name varchar(255) not null, directory_id bigint not null, primary key (id));
create table cwd_property (property_key varchar(255) not null, property_name varchar(255) not null, property_value varchar(4000), primary key (property_key, property_name));
create table cwd_token (id bigint not null, directory_id bigint not null, entity_name varchar(255) not null, random_number bigint not null, identifier_hash varchar(255) not null, random_hash varchar(255) not null, created_date timestamp not null, last_accessed_date timestamp not null, last_accessed_time bigint not null, duration bigint, primary key (id));
create table cwd_user (id bigint not null, user_name varchar(255) not null, lower_user_name varchar(255) not null, active char(255) not null, created_date timestamp not null, updated_date timestamp not null, first_name varchar(255), lower_first_name varchar(255), last_name varchar(255), lower_last_name varchar(255), display_name varchar(255), lower_display_name varchar(255), email_address varchar(255), lower_email_address varchar(255), external_id varchar(255), directory_id bigint not null, credential varchar(255), primary key (id));
create table cwd_user_attribute (id bigint not null, user_id bigint not null, directory_id bigint not null, attribute_name varchar(255) not null, attribute_value varchar(255), attribute_lower_value varchar(255), primary key (id));
create table cwd_user_credential_record (id bigint not null, user_id bigint not null, password_hash varchar(255) not null, list_index integer, primary key (id));
create table cwd_webhook (id bigint not null, endpoint_url varchar(255) not null, application_id bigint not null, token varchar(255), oldest_failure_date timestamp, failures_since_last_success bigint not null, primary key (id));
alter table cru_user_profile add column cru_timezone varchar(255);
alter table cwd_app_dir_group_mapping add constraint uk_app_dir_group unique (app_dir_mapping_id, group_name);
create index idx_app_dir_group_group_dir on cwd_app_dir_group_mapping (directory_id, group_name);
alter table cwd_app_dir_mapping add constraint uk_app_dir unique (application_id, directory_id);
alter table cwd_application add constraint uk_app_l_name unique (lower_application_name);
create index idx_app_active on cwd_application (active);
create index idx_app_type on cwd_application (application_type);
alter table cwd_application_alias add constraint uk_alias_app_l_username unique (application_id, lower_user_name);
alter table cwd_application_alias add constraint uk_alias_app_l_alias unique (application_id, lower_alias_name);
alter table cwd_directory add constraint uk_dir_l_name unique (lower_directory_name);
create index idx_dir_active on cwd_directory (active);
create index idx_dir_l_impl_class on cwd_directory (lower_impl_class);
create index idx_dir_type on cwd_directory (directory_type);
alter table cwd_expirable_user_token add constraint uk_expirable_user_token unique (token);
alter table cwd_group add constraint uk_group_name_dir_id unique (lower_group_name, directory_id);
create index idx_group_active on cwd_group (active, directory_id);
create index idx_group_dir_id on cwd_group (directory_id);
alter table cwd_group_attribute add constraint uk_group_name_attr_lval unique (group_id, attribute_name, attribute_lower_value);
create index idx_group_attr_group_id on cwd_group_attribute (group_id);
create index idx_group_attr_dir_name_lval on cwd_group_attribute (directory_id, attribute_name, attribute_lower_value);
alter table cwd_membership add constraint uk_mem_parent_child_type unique (parent_id, child_id, membership_type);
create index idx_mem_dir_parent_child on cwd_membership (membership_type, lower_parent_name, lower_child_name, directory_id);
create index idx_mem_dir_parent on cwd_membership (membership_type, lower_parent_name, directory_id);
create index idx_mem_dir_child on cwd_membership (membership_type, lower_child_name, directory_id);
alter table cwd_token add constraint uk_token_id_hash unique (identifier_hash);
create index idx_token_dir_id on cwd_token (directory_id);
create index idx_token_name_dir_id on cwd_token (directory_id, entity_name);
create index idx_token_key on cwd_token (random_hash);
create index idx_token_last_access on cwd_token (last_accessed_date);
alter table cwd_user add constraint uk_user_name_dir_id unique (lower_user_name, directory_id);
create index idx_user_active on cwd_user (active, directory_id);
create index idx_user_lower_first_name on cwd_user (lower_first_name, directory_id);
create index idx_user_lower_last_name on cwd_user (lower_last_name, directory_id);
create index idx_user_lower_display_name on cwd_user (lower_display_name, directory_id);
create index idx_user_lower_email_address on cwd_user (lower_email_address, directory_id);
create index idx_external_id on cwd_user (external_id);
create index idx_user_name_dir_id on cwd_user (directory_id);
alter table cwd_user_attribute add constraint uk_user_attr_name_lval unique (user_id, attribute_name, attribute_lower_value);
create index idx_user_attr_user_id on cwd_user_attribute (user_id);
create index idx_user_attr_dir_name_lval on cwd_user_attribute (directory_id, attribute_name, attribute_lower_value);
alter table cwd_webhook add constraint uk_webhook_url_app unique (endpoint_url, application_id);
create index idx_webhook_url_app on cwd_webhook (application_id);
alter table cwd_app_dir_group_mapping add constraint fk_app_dir_group_mapping foreign key (app_dir_mapping_id) references cwd_app_dir_mapping;
alter table cwd_app_dir_group_mapping add constraint fk_app_dir_group_app foreign key (application_id) references cwd_application;
alter table cwd_app_dir_group_mapping add constraint fk_app_dir_group_dir foreign key (directory_id) references cwd_directory;
alter table cwd_app_dir_mapping add constraint fk_app_dir_app foreign key (application_id) references cwd_application;
alter table cwd_app_dir_mapping add constraint fk_app_dir_dir foreign key (directory_id) references cwd_directory;
alter table cwd_app_dir_operation add constraint fk_app_dir_mapping foreign key (app_dir_mapping_id) references cwd_app_dir_mapping;
alter table cwd_application_address add constraint fk_application_address foreign key (application_id) references cwd_application;
alter table cwd_application_alias add constraint fk_alias_app_id foreign key (application_id) references cwd_application;
alter table cwd_application_attribute add constraint fk_application_attribute foreign key (application_id) references cwd_application;
alter table cwd_directory_attribute add constraint fk_directory_attribute foreign key (directory_id) references cwd_directory;
alter table cwd_directory_operation add constraint fk_directory_operation foreign key (directory_id) references cwd_directory;
alter table cwd_granted_perm add constraint fk_permission_group foreign key (group_mapping) references cwd_app_dir_group_mapping;
alter table cwd_group add constraint fk_directory_id foreign key (directory_id) references cwd_directory;
alter table cwd_group_attribute add constraint fk_group_attr_id_group_id foreign key (group_id) references cwd_group;
alter table cwd_group_attribute add constraint fk_group_attr_dir_id foreign key (directory_id) references cwd_directory;
alter table cwd_membership add constraint fk_membership_dir foreign key (directory_id) references cwd_directory;
alter table cwd_user add constraint fk_user_dir_id foreign key (directory_id) references cwd_directory;
alter table cwd_user_attribute add constraint fk_user_attribute_id_user_id foreign key (user_id) references cwd_user;
alter table cwd_user_attribute add constraint fk_user_attr_dir_id foreign key (directory_id) references cwd_directory;
alter table cwd_user_credential_record add constraint fk_user_cred_user foreign key (user_id) references cwd_user;
alter table cwd_webhook add constraint fk_application_webhooks foreign key (application_id) references cwd_application;
create table cru_global_permission (cru_id integer not null, cru_group varchar(255) not null, cru_fisheye_user boolean not null, cru_crucible_user boolean not null, primary key (cru_id));
alter table cru_global_permission add constraint uk_gp_group_name unique (cru_group);
create index cru_idx_perm_fisheye_user on cru_global_permission (cru_fisheye_user);
create index cru_idx_perm_crucible_user on cru_global_permission (cru_crucible_user);

INSERT INTO cwd_application (id, application_name, lower_application_name, created_date, updated_date, active, description, application_type, credential) VALUES (1, 'crowd-embedded', 'crowd-embedded', NOW(), NOW(), 'T', null, 'CROWD', 'X');
INSERT INTO cwd_application_attribute (application_id, attribute_value, attribute_name) VALUES (1, 'true', 'atlassian_sha1_applied');
INSERT INTO cwd_application_attribute (application_id, attribute_value, attribute_name) VALUES (1, 'true', 'aggregateMemberships');

INSERT INTO cwd_directory (id, directory_name, lower_directory_name, created_date, updated_date, active, description, impl_class, lower_impl_class, directory_type) VALUES (1, 'Internal Directory', 'internal directory', NOW(), NOW(), 'T', null, 'com.atlassian.crowd.directory.InternalDirectory', 'com.atlassian.crowd.directory.internaldirectory', 'INTERNAL');
INSERT INTO cwd_directory_attribute (directory_id, attribute_value, attribute_name) VALUES (1, 'atlassian-security', 'user_encryption_method');

INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'CREATE_GROUP');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'CREATE_ROLE');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'CREATE_USER');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'DELETE_GROUP');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'DELETE_ROLE');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'DELETE_USER');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_GROUP');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_GROUP_ATTRIBUTE');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_ROLE');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_ROLE_ATTRIBUTE');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_USER');
INSERT INTO cwd_directory_operation (directory_id, operation_type) VALUES (1, 'UPDATE_USER_ATTRIBUTE');

INSERT INTO cwd_app_dir_mapping (id, application_id, directory_id, allow_all, list_index) VALUES (1, 1, 1, 'T', 0);
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'CREATE_GROUP');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'CREATE_ROLE');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'CREATE_USER');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'DELETE_GROUP');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'DELETE_ROLE');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'DELETE_USER');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_GROUP');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_GROUP_ATTRIBUTE');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_ROLE');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_ROLE_ATTRIBUTE');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_USER');
INSERT INTO cwd_app_dir_operation (app_dir_mapping_id, operation_type) VALUES (1, 'UPDATE_USER_ATTRIBUTE');
