DELETE FROM cru_reply r
WHERE cru_reply_id IN
( SELECT DISTINCT cru_reply_id FROM cru_reply
    GROUP BY cru_reply_id HAVING count(cru_reply_id) > 1)
AND NOT EXISTS
( SELECT * FROM cru_comment c
    WHERE r.cru_comment_id = cru_reply_to_comment_id
    AND r.cru_reply_id = c.cru_comment_id);

UPDATE cru_comment
SET cru_reply_to_comment_id =
  ( SELECT cru_reply.cru_comment_id
    FROM cru_reply
    WHERE cru_reply.cru_reply_id = cru_comment.cru_comment_id)
  WHERE EXISTS
      ( SELECT cru_reply.cru_comment_id
        FROM cru_reply
        WHERE cru_reply.cru_reply_id= cru_comment.cru_comment_id);

UPDATE cru_version SET cru_version = 58 WHERE cru_version_id = 1;
