alter table cru_comment drop constraint FKE5A1D10644A616B5;
alter table cru_comment drop constraint FKE5A1D106C50DAE44;
alter table cru_comment drop constraint FKE5A1D10674DF349C;
alter table cru_comment_field drop constraint FK44917881EDCA5CBF;
alter table cru_comment_field drop constraint FK449178819408AA2E;
alter table cru_comment_read_status drop constraint FKC361750249A772D1;
alter table cru_comment_read_status drop constraint FKC3617502A88A4012;
alter table cru_completed_frx drop constraint FK927E9E9F1BD6EA47;
alter table cru_completed_frx drop constraint FK927E9E9F73591D1A;
alter table cru_content_root drop constraint FK2DAE96A1B37C2C45;
alter table cru_feindex_msg drop constraint FKB56857DC665511F3;
alter table cru_fr_detail drop constraint FK4F2200B487D2F44;
alter table cru_frx drop constraint FK3E2EDB5344A616B5;
alter table cru_frx_comment drop constraint FK92896D73EDCA5CBF;
alter table cru_frx_comment drop constraint FK92896D7373591D1A;
alter table cru_frx_revision drop constraint FKD3011B47DB653A32;
alter table cru_frx_revision drop constraint FKD3011B4773591D1A;
alter table cru_inline_comment drop constraint FKCEDB232EDCA5CBF;
alter table cru_inline_comment drop constraint FKCEDB23273591D1A;
alter table cru_inline_comment_to_frx_revision drop constraint FK25B4CCC5276E223A;
alter table cru_inline_comment_to_frx_revision drop constraint FK25B4CCC58DEFF736;
alter table cru_invitees drop constraint FK18230FB044A616B5;
alter table cru_notification drop constraint FK1F9536A42C3DCA3D;
alter table cru_notification drop constraint FK1F9536A4B0A0252A;
alter table cru_patch drop constraint FK6E6A80AFE35E156A;
alter table cru_patch drop constraint FK6E6A80AF2C3DCA3D;
alter table cru_patch_revision drop constraint FKD573BD6B487D2F44;
alter table cru_patch_revision drop constraint FKD573BD6B4A7C3D5F;
alter table cru_proj_allowed_grp drop constraint FK893AB525F7B16A7F;
alter table cru_proj_allowed_reviewer drop constraint FK1E8211C5F7B16A7F;
alter table cru_proj_allowed_reviewer drop constraint FK1E8211C5C50DAE44;
alter table cru_proj_default_grp drop constraint FK1502953EF7B16A7F;
alter table cru_proj_default_reviewer drop constraint FK3F4F594CF7B16A7F;
alter table cru_proj_default_reviewer drop constraint FK3F4F594CC50DAE44;
alter table cru_project drop constraint FK9A8C2DC0F2648A64;
alter table cru_project drop constraint FK9A8C2DC0E2A633FC;
alter table cru_ps_all_user drop constraint FK830D758C7E705564;
alter table cru_ps_anon drop constraint FK9B5B9A2F7E705564;
alter table cru_ps_group drop constraint FKD06E0B7C7E705564;
alter table cru_ps_review_role drop constraint FK8204BC3A7E705564;
alter table cru_ps_user drop constraint FK9B64C32E7E705564;
alter table cru_recipient drop constraint FK8E6F47009F44EBB8;
alter table cru_recipient drop constraint FK8E6F4700A88A4012;
alter table cru_reply drop constraint FK6E887351EDCA5CBF;
alter table cru_reply drop constraint FK6E8873513CEA9294;
alter table cru_review drop constraint FK6288A3D1B214061;
alter table cru_review drop constraint FK6288A3D1B37C2C45;
alter table cru_review drop constraint FK6288A3D17492E860;
alter table cru_review_comment drop constraint FKBE49D7F144A616B5;
alter table cru_review_comment drop constraint FKBE49D7F1EDCA5CBF;
alter table cru_review_field drop constraint FKCC23C70C44A616B5;
alter table cru_review_field drop constraint FKCC23C70C9408AA2E;
alter table cru_review_participant drop constraint FK54EBFC544A616B5;
alter table cru_review_participant drop constraint FK54EBFC5A88A4012;
alter table cru_revision drop constraint FKE2F52A14E35E156A;
alter table cru_revision drop constraint FKE2F52A1434AAD25A;
alter table cru_revpermaid drop constraint FK5538824244A616B5;
alter table cru_state_change drop constraint FKF37CE4D7A88A4012;
alter table cru_upload_item drop constraint FK70E1F5B8A88A4012;

drop index cru_idx_star_name if exists;
drop index cru_idx_int_key2 if exists;
drop index cru_idx_int_key5 if exists;
drop index cru_idx_string_key4 if exists;
drop index cru_idx_int_key3 if exists;
drop index cru_idx_string_key5 if exists;
drop index cru_idx_string_key3 if exists;
drop index cru_idx_int_key1 if exists;
drop index cru_idx_string_key1 if exists;
drop index cru_idx_string_key2 if exists;
drop index cru_idx_star_type if exists;
drop index cru_idx_int_key4 if exists;
drop index cru_idx_comment_issue_key if exists;
drop index idx_comment_deleted if exists;
drop index idx_comment_draft if exists;
drop index idx_comment_user if exists;
drop index idx_comment_defectApproved if exists;
drop index idx_comment_defectRaised if exists;
drop index cru_idx_comment_read_status_user if exists;
drop index cru_idx_comment_read_status_comment if exists;
drop index cru_idx_committer_mapping_user_name if exists;
drop index idx_femsg_filerevision if exists;
drop index idx_femsg_review if exists;
drop index idx_field_name if exists;
drop index idx_field_scope if exists;
drop index idx_frx_review if exists;
drop index idx_rc_frx if exists;
drop index idx_frxrev_frx if exists;
drop index idx_frxrev_revision if exists;
drop index idx_ic_frx if exists;
drop index idx_icrd_ic if exists;
drop index idx_icrd_frx_rev if exists;
drop index notification_ref1_idx if exists;
drop index notification_ref2_idx if exists;
drop index notifiaction_review_idx if exists;
drop index patch_review_idx if exists;
drop index patch_ui_idx if exists;
drop index ps_name_idx if exists;
drop index proj_name_idx if exists;
drop index proj_key_idx if exists;
drop index recipient_email_idx if exists;
drop index recipient_rss_idx if exists;
drop index recipient_uiack_idx if exists;
drop index cru_idx_issue_key if exists;
drop index cru_idx_due_date if exists;
drop index cru_idx_status_change if exists;
drop index fr_source_idx if exists;
drop index fr_name_idx if exists;
drop index fr_rev_idx if exists;
drop index fr_author_idx if exists;
drop index scl_timestamp_idx if exists;
drop index scl_superseded_idx if exists;
drop index scl_review_idx if exists;
drop index cru_idx_stored_path if exists;
drop index upload_user_idx if exists;
drop index idx_user_name if exists;

create alias TSTOL for "com.cenqua.crucible.hibernate.upgrade.HsqlStoredProc.timestampToLong";

create table newcru_base_star_model (cru_star_id integer not null, cru_item_type varchar(80) not null, cru_string_key1 varchar(255), cru_string_key2 varchar(255), cru_string_key3 varchar(255), cru_string_key4 varchar(255), cru_string_key5 varchar(255), cru_int_key1 integer, cru_int_key2 integer, cru_int_key3 integer, cru_int_key4 integer, cru_int_key5 integer, cru_text_key1 longvarchar, cru_text_key2 longvarchar, cru_user_name varchar(255), cru_date_created bigint, cru_label varchar(255), primary key (cru_star_id));
insert into newcru_base_star_model (select cru_star_id, cru_item_type, cru_string_key1, cru_string_key2, cru_string_key3, cru_string_key4, cru_string_key5, cru_int_key1, cru_int_key2, cru_int_key3, cru_int_key4, cru_int_key5, cru_text_key1, cru_text_key2, cru_user_name, TSTOL(cru_date_created), cru_label from cru_base_star_model);
drop table cru_base_star_model;
alter table newcru_base_star_model rename to cru_base_star_model;

create table newcru_comment (cru_comment_id integer not null, cru_create_date bigint, cru_message longvarchar not null, cru_draft bit not null, cru_deleted bit not null, cru_defect_raised bit not null, cru_comment_issue_key varchar(80), cru_defect_approved bit not null, cru_user_id integer, cru_review_id integer not null, cru_reply_to_comment_id integer, primary key (cru_comment_id));
insert into newcru_comment (select cru_comment_id, TSTOL(cru_create_date), cru_message, cru_draft, cru_deleted, cru_defect_raised, cru_comment_issue_key, cru_defect_approved, cru_user_id, cru_review_id, cru_reply_to_comment_id from cru_comment);
drop table cru_comment;
alter table newcru_comment rename to cru_comment;

create table newcru_field (cru_field_id integer not null, cru_config_version integer, cru_field_scope varchar(80), cru_name varchar(80), cru_string_val varchar(255), cru_int_val integer, cru_boolean_val bit, cru_date bigint, primary key (cru_field_id));
insert into  newcru_field (select cru_field_id, cru_config_version, cru_field_scope, cru_name, cru_string_val, cru_int_val, cru_boolean_val, TSTOL(cru_date) from cru_field);
drop table cru_field;
alter table newcru_field rename to cru_field;

create table newcru_frx (cru_frx_id integer not null, cru_when_added bigint, cru_reviewed integer, cru_further_action integer, cru_review_scope integer, cru_frx_order integer, cru_show_as_diff bit not null, cru_review_id integer not null, primary key (cru_frx_id));
insert into  newcru_frx (select cru_frx_id, TSTOL(cru_when_added), cru_reviewed, cru_further_action, cru_review_scope, cru_frx_order, cru_show_as_diff, cru_review_id from cru_frx);
drop table cru_frx;
alter table newcru_frx rename to cru_frx;

create table newcru_frx_revision (cru_frx_rev_id integer not null, cru_date_added bigint not null, cru_revision_order integer not null, cru_revision integer, cru_frx_id integer not null, primary key (cru_frx_rev_id));
insert into  newcru_frx_revision (select cru_frx_rev_id, TSTOL(cru_date_added), cru_revision_order, cru_revision, cru_frx_id from cru_frx_revision);
drop table cru_frx_revision;
alter table newcru_frx_revision rename to cru_frx_revision;

create table newcru_logitem (cru_logitem_id integer not null, cru_create_date bigint, cru_item longvarchar, primary key (cru_logitem_id));
insert into  newcru_logitem (select cru_logitem_id, TSTOL(cru_create_date), cru_item from cru_logitem);
drop table cru_logitem;
alter table newcru_logitem rename to cru_logitem;

create table newcru_notification (cru_notification_id integer not null, cru_note_type varchar(255) not null, cru_create_date bigint, cru_actioner integer, cru_note longvarchar, cru_review integer, cru_ref1 integer, cru_ref2 integer, primary key (cru_notification_id));
insert into  newcru_notification (select cru_notification_id, cru_note_type, TSTOL(cru_create_date), cru_actioner, cru_note, cru_review, cru_ref1, cru_ref2 from cru_notification);
drop table cru_notification;
alter table newcru_notification rename to cru_notification;

create table newcru_review (cru_review_id integer not null, cru_name varchar(255), cru_default_source varchar(80), cru_state varchar(80), cru_description longvarchar, cru_summary longvarchar, cru_allow_reviewer_to_join bit, cru_create_date bigint, cru_metrics_version integer, cru_all_reviewers_complete bit, cru_due_date bigint, cru_issue_key varchar(80), cru_parent_review integer, cru_creator integer, cru_project integer, primary key (cru_review_id));
insert into  newcru_review (select cru_review_id, cru_name, cru_default_source, cru_state, cru_description, cru_summary, cru_allow_reviewer_to_join, TSTOL(cru_create_date), cru_metrics_version, cru_all_reviewers_complete, TSTOL(cru_due_date), cru_issue_key, cru_parent_review, cru_creator, cru_project from cru_review); 
drop table cru_review;
alter table newcru_review rename to cru_review;

create table newcru_review_participant (cru_participant_id integer not null, cru_review_id integer not null, cru_user integer, cru_author bit, cru_moderator bit, cru_reviewer bit, cru_all_complete bit, cru_last_read bigint, cru_status_change bigint, primary key (cru_participant_id), unique (cru_review_id, cru_user));
insert into  newcru_review_participant (select cru_participant_id, cru_review_id, cru_user, cru_author, cru_moderator, cru_reviewer, cru_all_complete, TSTOL(cru_last_read), TSTOL(cru_status_change) from cru_review_participant);
drop table cru_review_participant;
alter table newcru_review_participant rename to cru_review_participant;

create table newcru_revision (cru_revision_id integer not null, cru_create_date bigint, cru_commit_date bigint, cru_author_name varchar(255), cru_deletion bit, cru_file_type varchar(15), cru_source_name varchar(100), cru_path integer, cru_revision varchar(100), cru_revision_display_name varchar(255), cru_upload_item integer, primary key (cru_revision_id), unique (cru_source_name, cru_path, cru_revision));
insert into  newcru_revision (select cru_revision_id, TSTOL(cru_create_date), TSTOL(cru_commit_date), cru_author_name, cru_deletion, cru_file_type, cru_source_name, cru_path, cru_revision, cru_revision_display_name, cru_upload_item from cru_revision);
drop table cru_revision;
alter table newcru_revision rename to cru_revision;

create table newcru_state_change (cru_id integer not null, cru_time_stamp bigint not null, cru_superseded bigint, cru_review_id integer not null, cru_new_state varchar(80) not null, cru_user integer not null, primary key (cru_id));
insert into  newcru_state_change (select cru_id, TSTOL(cru_time_stamp), TSTOL(cru_superseded), cru_review_id, cru_new_state, cru_user from cru_state_change);
drop table cru_state_change;
alter table newcru_state_change rename to cru_state_change;

create table newcru_upload_item (cru_upload_id integer not null, cru_create_date bigint, cru_user integer, cru_description varchar(1000), cru_charset varchar(80), cru_original_name varchar(1000), cru_original_content_type varchar(80), primary key (cru_upload_id));
insert into  newcru_upload_item (select cru_upload_id, TSTOL(cru_create_date), cru_user, cru_description, cru_charset, cru_original_name, cru_original_content_type from cru_upload_item);
drop table cru_upload_item;
alter table newcru_upload_item rename to cru_upload_item;

create index cru_idx_string_key5 on cru_base_star_model (cru_string_key5);
create index cru_idx_string_key4 on cru_base_star_model (cru_string_key4);
create index cru_idx_star_name on cru_base_star_model (cru_user_name);
create index cru_idx_int_key2 on cru_base_star_model (cru_int_key2);
create index cru_idx_string_key3 on cru_base_star_model (cru_string_key3);
create index cru_idx_int_key3 on cru_base_star_model (cru_int_key3);
create index cru_idx_string_key2 on cru_base_star_model (cru_string_key2);
create index cru_idx_int_key4 on cru_base_star_model (cru_int_key4);
create index cru_idx_string_key1 on cru_base_star_model (cru_string_key1);
create index cru_idx_int_key5 on cru_base_star_model (cru_int_key5);
create index cru_idx_int_key1 on cru_base_star_model (cru_int_key1);
create index cru_idx_star_type on cru_base_star_model (cru_item_type);
create index idx_comment_defectApproved on cru_comment (cru_defect_approved);
create index idx_comment_deleted on cru_comment (cru_deleted);
create index cru_idx_comment_issue_key on cru_comment (cru_comment_issue_key);
create index idx_comment_user on cru_comment (cru_user_id);
create index idx_comment_draft on cru_comment (cru_draft);
create index idx_comment_defectRaised on cru_comment (cru_defect_raised);
alter table cru_comment add constraint FKE5A1D10644A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_comment add constraint FKE5A1D106C50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_comment add constraint FKE5A1D10674DF349C foreign key (cru_reply_to_comment_id) references cru_comment;
alter table cru_comment_field add constraint FK44917881EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_comment_field add constraint FK449178819408AA2E foreign key (cru_field_id) references cru_field;
create index cru_idx_comment_read_status_user on cru_comment_read_status (cru_user);
create index cru_idx_comment_read_status_comment on cru_comment_read_status (cru_comment);
alter table cru_comment_read_status add constraint FKC3617502A88A4012 foreign key (cru_user) references cru_user;
alter table cru_comment_read_status add constraint FKC361750249A772D1 foreign key (cru_comment) references cru_comment;
create index cru_idx_committer_mapping_user_name on cru_committer_user_mapping (cru_user_name);
alter table cru_completed_frx add constraint FK927E9E9F1BD6EA47 foreign key (cru_participant_id) references cru_review_participant;
alter table cru_completed_frx add constraint FK927E9E9F73591D1A foreign key (cru_frx_id) references cru_frx;
alter table cru_content_root add constraint FK2DAE96A1B37C2C45 foreign key (cru_project) references cru_project;
create index idx_femsg_filerevision on cru_feindex_msg (cru_fr_id);
create index idx_femsg_review on cru_feindex_msg (cru_review_id);
alter table cru_feindex_msg add constraint FKB56857DC665511F3 foreign key (cru_fr_id) references cru_revision;
create index idx_field_scope on cru_field (cru_field_scope);
create index idx_field_name on cru_field (cru_name);
alter table cru_fr_detail add constraint FK4F2200B487D2F44 foreign key (cru_revision_id) references cru_revision;
create index idx_frx_review on cru_frx (cru_review_id);
alter table cru_frx add constraint FK3E2EDB5344A616B5 foreign key (cru_review_id) references cru_review;
create index idx_rc_frx on cru_frx_comment (cru_frx_id);
alter table cru_frx_comment add constraint FK92896D73EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_frx_comment add constraint FK92896D7373591D1A foreign key (cru_frx_id) references cru_frx;
create index idx_frxrev_frx on cru_frx_revision (cru_frx_id);
create index idx_frxrev_revision on cru_frx_revision (cru_revision);
alter table cru_frx_revision add constraint FKD3011B47DB653A32 foreign key (cru_revision) references cru_revision;
alter table cru_frx_revision add constraint FKD3011B4773591D1A foreign key (cru_frx_id) references cru_frx;
create index idx_ic_frx on cru_inline_comment (cru_frx_id);
alter table cru_inline_comment add constraint FKCEDB232EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_inline_comment add constraint FKCEDB23273591D1A foreign key (cru_frx_id) references cru_frx;
create index idx_icrd_frx_rev on cru_inline_comment_to_frx_revision (cru_frx_rev_id);
create index idx_icrd_ic on cru_inline_comment_to_frx_revision (cru_inline_comment_id);
alter table cru_inline_comment_to_frx_revision add constraint FK25B4CCC5276E223A foreign key (cru_inline_comment_id) references cru_inline_comment;
alter table cru_inline_comment_to_frx_revision add constraint FK25B4CCC58DEFF736 foreign key (cru_frx_rev_id) references cru_frx_revision;
alter table cru_invitees add constraint FK18230FB044A616B5 foreign key (cru_review_id) references cru_review;
create index notifiaction_review_idx on cru_notification (cru_review);
create index notification_ref2_idx on cru_notification (cru_ref2);
create index notification_ref1_idx on cru_notification (cru_ref1);
alter table cru_notification add constraint FK1F9536A42C3DCA3D foreign key (cru_review) references cru_review;
alter table cru_notification add constraint FK1F9536A4B0A0252A foreign key (cru_actioner) references cru_user;
create index patch_review_idx on cru_patch (cru_review);
create index patch_ui_idx on cru_patch (cru_upload_item);
alter table cru_patch add constraint FK6E6A80AFE35E156A foreign key (cru_upload_item) references cru_upload_item;
alter table cru_patch add constraint FK6E6A80AF2C3DCA3D foreign key (cru_review) references cru_review;
alter table cru_patch_revision add constraint FKD573BD6B4A7C3D5F foreign key (cru_patch_id) references cru_patch;
alter table cru_patch_revision add constraint FKD573BD6B487D2F44 foreign key (cru_revision_id) references cru_revision;
create index ps_name_idx on cru_perm_scheme (cru_name);
alter table cru_proj_allowed_grp add constraint FK893AB525F7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5C50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5F7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_default_grp add constraint FK1502953EF7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_default_reviewer add constraint FK3F4F594CC50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_proj_default_reviewer add constraint FK3F4F594CF7B16A7F foreign key (cru_project_id) references cru_project;
create index proj_name_idx on cru_project (cru_name);
create index proj_key_idx on cru_project (cru_proj_key);
alter table cru_project add constraint FK9A8C2DC0F2648A64 foreign key (cru_permission_scheme) references cru_perm_scheme;
alter table cru_project add constraint FK9A8C2DC0E2A633FC foreign key (cru_default_moderator) references cru_user;
alter table cru_ps_all_user add constraint FK830D758C7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_anon add constraint FK9B5B9A2F7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_group add constraint FKD06E0B7C7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_review_role add constraint FK8204BC3A7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_user add constraint FK9B64C32E7E705564 foreign key (cru_ps) references cru_perm_scheme;
create index recipient_email_idx on cru_recipient (cru_email);
create index recipient_rss_idx on cru_recipient (cru_rss);
create index recipient_uiack_idx on cru_recipient (cru_ui_ack);
alter table cru_recipient add constraint FK8E6F4700A88A4012 foreign key (cru_user) references cru_user;
alter table cru_recipient add constraint FK8E6F47009F44EBB8 foreign key (cru_notification_id) references cru_notification;
alter table cru_reply add constraint FK6E887351EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_reply add constraint FK6E8873513CEA9294 foreign key (cru_reply_id) references cru_comment;
create index cru_idx_due_date on cru_review (cru_due_date);
create index cru_idx_issue_key on cru_review (cru_issue_key);
alter table cru_review add constraint FK6288A3D17492E860 foreign key (cru_parent_review) references cru_review;
alter table cru_review add constraint FK6288A3D1B37C2C45 foreign key (cru_project) references cru_project;
alter table cru_review add constraint FK6288A3D1B214061 foreign key (cru_creator) references cru_user;
alter table cru_review_comment add constraint FKBE49D7F1EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_review_comment add constraint FKBE49D7F144A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_review_field add constraint FKCC23C70C9408AA2E foreign key (cru_field_id) references cru_field;
alter table cru_review_field add constraint FKCC23C70C44A616B5 foreign key (cru_review_id) references cru_review;
create index cru_idx_status_change on cru_review_participant (cru_status_change);
alter table cru_review_participant add constraint FK54EBFC5A88A4012 foreign key (cru_user) references cru_user;
alter table cru_review_participant add constraint FK54EBFC544A616B5 foreign key (cru_review_id) references cru_review;
create index fr_name_idx on cru_revision (cru_revision_display_name);
create index fr_rev_idx on cru_revision (cru_revision);
create index fr_author_idx on cru_revision (cru_author_name);
create index fr_source_idx on cru_revision (cru_source_name);
alter table cru_revision add constraint FKE2F52A1434AAD25A foreign key (cru_path) references cru_stored_path;
alter table cru_revision add constraint FKE2F52A14E35E156A foreign key (cru_upload_item) references cru_upload_item;
alter table cru_revpermaid add constraint FK5538824244A616B5 foreign key (cru_review_id) references cru_review;
create index scl_review_idx on cru_state_change (cru_review_id);
create index scl_timestamp_idx on cru_state_change (cru_time_stamp);
create index scl_superseded_idx on cru_state_change (cru_superseded);
alter table cru_state_change add constraint FKF37CE4D7A88A4012 foreign key (cru_user) references cru_user;
create index cru_idx_stored_path on cru_stored_path (cru_path);
create index upload_user_idx on cru_upload_item (cru_user);
alter table cru_upload_item add constraint FK70E1F5B8A88A4012 foreign key (cru_user) references cru_user;
create index idx_user_name on cru_user (cru_user_name);

UPDATE cru_version SET cru_version = 42 WHERE cru_version_id = 1;