alter table cru_state_change add column cru_user integer;
delete from cru_state_change where cru_review_id is null;

drop index scl_review_idx if exists;
drop index scl_timestamp_idx if exists;
drop index scl_superseded_idx if exists;

create table new_cru_state_change (cru_id integer not null, cru_time_stamp timestamp not null, cru_superseded timestamp, cru_review_id integer not null, cru_new_state varchar(80) not null, cru_user integer not null, primary key (cru_id));
insert into new_cru_state_change (select cru_id, cru_time_stamp, cru_superseded, cs.cru_review_id,cru_new_state,
  (SELECT p.cru_user FROM cru_review_participant p WHERE cs.cru_review_id = p.cru_review_id AND p.cru_moderator = true limit 1) from cru_state_change cs join cru_review r on (r.cru_review_id = cs.cru_review_id));
drop table cru_state_change if exists;
alter table new_cru_state_change rename to cru_state_change;

create index scl_review_idx on cru_state_change (cru_review_id);
create index scl_timestamp_idx on cru_state_change (cru_time_stamp);
create index scl_superseded_idx on cru_state_change (cru_superseded);
alter table cru_state_change add constraint FKF37CE4D7A88A4012 foreign key (cru_user) references cru_user;
delete from cru_base_star_model;
UPDATE cru_version SET cru_version = 37 WHERE cru_version_id = 1;

