# drop constraints on cru_revision_comment which will be deleted at the end:
drop index idx_rc_frx if exists;
drop index idx_rc_comment if exists;
drop index idx_rc_revision if exists;
alter table cru_revision_comment drop constraint FKB2B96B34DB653A32;
alter table cru_revision_comment drop constraint FKB2B96B3473591D1A;
alter table cru_revision_comment drop constraint FKB2B96B3449A772D1;


create table cru_frx_revision (cru_frx_rev_id integer not null, cru_date_added timestamp not null, cru_revision_order integer not null, cru_revision integer, cru_frx_id integer not null, primary key (cru_frx_rev_id));
create index idx_frxrev_frx on cru_frx_revision (cru_frx_id);
create index idx_frxrev_revision on cru_frx_revision (cru_revision);
create sequence cru_frx_rev_id_seq;
insert into cru_frx_revision (select NEXT VALUE FOR cru_frx_rev_id_seq, cru_when_added, 0, cru_from_revision, cru_frx_id from cru_frx where cru_from_revision is not null);
insert into cru_frx_revision (select NEXT VALUE FOR cru_frx_rev_id_seq, cru_when_added, 0, cru_file_revision, cru_frx_id from cru_frx where cru_file_revision is not null and cru_from_revision is null);
insert into cru_frx_revision (select NEXT VALUE FOR cru_frx_rev_id_seq, cru_when_added, 1, cru_file_revision, cru_frx_id from cru_frx where cru_file_revision is not null and cru_from_revision is not null);
drop sequence cru_frx_rev_id_seq;

alter table cru_frx add column cru_show_as_diff bit;
update cru_frx set cru_show_as_diff = (cru_from_revision is not null);
alter table cru_frx alter column cru_show_as_diff set not null;

alter table cru_frx drop constraint FK3E2EDB5344A616B5;
alter table cru_frx drop constraint FK3E2EDB53D70B78C3;
alter table cru_frx drop constraint FK3E2EDB537D43EA55;
alter table cru_completed_frx drop constraint FK927E9E9F73591D1A;
drop index idx_frx_fr;
drop index idx_frx_fromfr;
drop index idx_frx_review;
alter table cru_frx rename to cru_frx_old;
create table cru_frx (cru_frx_id integer not null, cru_when_added timestamp, cru_reviewed integer, cru_further_action integer, cru_review_scope integer, cru_frx_order integer, cru_show_as_diff bit not null, cru_review_id integer not null, primary key (cru_frx_id));
insert into cru_frx (select cru_frx_id, cru_when_added timestamp, cru_reviewed, cru_further_action, cru_review_scope, cru_frx_order, cru_show_as_diff, cru_review_id from cru_frx_old)
drop table cru_frx_old;

alter table cru_frx add constraint FK3E2EDB5344A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_completed_frx add constraint FK927E9E9F73591D1A foreign key (cru_frx_id) references cru_frx;
create index idx_frx_review on cru_frx (cru_review_id);

alter table cru_frx_revision add constraint FKD3011B47DB653A32 foreign key (cru_revision) references cru_revision;
alter table cru_frx_revision add constraint FKD3011B4773591D1A foreign key (cru_frx_id) references cru_frx;


create table cru_frx_comment (cru_comment_id integer not null, cru_frx_id integer not null, primary key (cru_comment_id));
create index idx_rc_frx on cru_frx_comment (cru_frx_id);
alter table cru_frx_comment add constraint FK92896D73EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_frx_comment add constraint FK92896D7373591D1A foreign key (cru_frx_id) references cru_frx;
insert into cru_frx_comment (select cru_comment, cru_frx_id from cru_revision_comment where cru_line_range is null);


create table cru_inline_comment (cru_comment_id integer not null, cru_frx_id integer not null, primary key (cru_comment_id));
create index idx_ic_frx on cru_inline_comment (cru_frx_id);
alter table cru_inline_comment add constraint FKCEDB232EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_inline_comment add constraint FKCEDB23273591D1A foreign key (cru_frx_id) references cru_frx;
insert into cru_inline_comment (cru_comment_id, cru_frx_id) (select distinct(cru_comment), cru_frx_id from cru_revision_comment where cru_line_range is not null);


create table cru_inline_comment_to_frx_revision (cru_ic_to_frx_rev_id integer not null, cru_line_range varchar(255) not null, cru_frx_rev_id integer not null, cru_inline_comment_id integer not null, primary key (cru_ic_to_frx_rev_id));
create index idx_icrd_frx_rev on cru_inline_comment_to_frx_revision (cru_frx_rev_id);
create index idx_icrd_ic on cru_inline_comment_to_frx_revision (cru_inline_comment_id);
alter table cru_inline_comment_to_frx_revision add constraint FK25B4CCC5276E223A foreign key (cru_inline_comment_id) references cru_inline_comment;
alter table cru_inline_comment_to_frx_revision add constraint FK25B4CCC58DEFF736 foreign key (cru_frx_rev_id) references cru_frx_revision;
create sequence cru_ic_to_frx_rev_id_seq;
insert into cru_inline_comment_to_frx_revision (
    select NEXT VALUE FOR cru_ic_to_frx_rev_id_seq, cru_revision_comment.cru_line_range, cru_frx_revision.cru_frx_rev_id, cru_revision_comment.cru_comment from cru_revision_comment, cru_frx_revision, cru_frx
    where cru_line_range is not null and
    cru_revision_comment.cru_frx_id = cru_frx.cru_frx_id and
    cru_frx.cru_frx_id = cru_frx_revision.cru_frx_id and
    cru_frx_revision.cru_revision = cru_revision_comment.cru_revision);
drop sequence cru_ic_to_frx_rev_id_seq;


drop table cru_revision_comment;

delete from cru_base_star_model;

UPDATE cru_version SET cru_version = 34 WHERE cru_version_id = 1;
