#create new db naming structure ready for multi db support
#checked order, names
create table cru_comment (cru_comment_id integer not null, cru_create_date timestamp, cru_message longvarchar not null, cru_draft bit not null, cru_deleted bit not null, cru_defect_raised bit not null, cru_defect_approved bit not null, cru_user_id integer, cru_review_id integer not null, cru_reply_to_comment_id integer, primary key (cru_comment_id));
insert into cru_comment (select COMMENT_ID, CREATE_DATE, message, draft, deleted, defectRaised, defectApproved, USER_ID, REVIEW_ID, REPLY_TO_COMMENT_ID from COMMENT);
#checked order, names
create table cru_comment_field (cru_comment_id integer not null, cru_field_id integer not null, cru_field_order integer not null, primary key (cru_comment_id, cru_field_order));
insert into cru_comment_field (select COMMENT_ID, FIELD_ID, FIELD_ORDER from COMMENT_FIELD);
#checked order, names
create table cru_completed_frx (cru_participant_id integer not null, cru_frx_id integer not null, primary key (cru_participant_id, cru_frx_id));
insert into cru_completed_frx (select PARTICIPANT_ID, FRX_ID from COMPLETED_FRX);
#checked order, names
create table cru_feindex_msg (cru_id integer not null, cru_fr_id integer, cru_review_id integer not null, primary key (cru_id));
insert into cru_feindex_msg (select ID, FR_ID, REVIEW_ID from FEINDEX_MSG);
#checked order, names
create table cru_field (cru_field_id integer not null, cru_config_version integer, cru_field_scope varchar(80), cru_name varchar(80), cru_string_val varchar(255), cru_int_val integer, cru_boolean_val bit, cru_date timestamp, primary key (cru_field_id));
insert into cru_field (select FIELD_ID, configVersion, fieldScope, name, stringVal, intVal, booleanVal, DATE from FIELD);
#checked order, names
create table cru_fr_detail (cru_revision_id integer not null, cru_value longvarchar, cru_name varchar(255) not null, primary key (cru_revision_id, cru_name));
insert into cru_fr_detail (select id, value, name from FR_DETAIL);
#checked order, names
create table cru_frx (cru_frx_id integer not null, cru_when_added timestamp, cru_reviewed integer, cru_further_action integer, cru_review_scope integer, cru_frx_order integer, cru_file_revision integer, cru_review_id integer not null, cru_from_revision integer, primary key (cru_frx_id), unique (cru_file_revision, cru_review_id));
insert into cru_frx (select FRX_ID, WHEN_ADDED, reviewed, furtherAction, reviewScope, FRX_ORDER, fileRevision, REVIEW_ID, fromRevision from FR_EXTRA);
#checked order, names
create table cru_invitees (cru_review_id integer not null, cru_address varchar(255));
insert into cru_invitees (select REVIEW_ID, ADDRESS from INVITEES);
#checked order, names
create table cru_logitem (cru_logitem_id integer not null, cru_create_date timestamp, cru_item longvarchar, primary key (cru_logitem_id));
insert into cru_logitem (select LOGITEM_ID, CREATE_DATE, item from LOGITEM);
#checked order, names
create table cru_metric_definition (cru_metric_id integer not null, cru_xml longvarchar, primary key (cru_metric_id));
insert into cru_metric_definition (select METRIC_ID, xml from METRIC_DEFINITION);
#checked order, names
create table cru_notification (cru_notification_id integer not null, cru_note_type varchar(255) not null, cru_create_date timestamp, cru_actioner integer, cru_note longvarchar, cru_review integer, cru_ref1 integer, cru_ref2 integer, primary key (cru_notification_id));
insert into cru_notification (select NOTIFICATION_ID, NOTE_TYPE, CREATE_DATE, actioner, note, review, ref1, ref2 from NOTIFICATION);
#checked order, names
create table cru_patch (cru_patch_id integer not null, cru_review integer, cru_uploadItem integer, primary key (cru_patch_id));
insert into cru_patch (select PATCH_ID, review, uploadItem from PATCH);
#checked order, names
create table cru_patch_revision (cru_PATCH_ID integer not null, cru_revision_id integer not null, cru_revision_order integer not null, primary key (cru_PATCH_ID, cru_revision_order));
insert into cru_patch_revision (select PATCH_ID, REVISION_ID, REVISION_ORDER from PATCH_REVISION);
#checked order, names
create table cru_perm_scheme (cru_ps_id integer not null, cru_name varchar(80), primary key (cru_ps_id), unique (cru_name));
insert into cru_perm_scheme (select PS_ID, name from PERM_SCHEME);
#checked order, names
create table cru_proj_allowed_grp (cru_project_id integer not null, cru_group_name varchar(255));
insert into cru_proj_allowed_grp (select PROJECT_ID, GROUP_NAME from CRUPROJECT_ALWDREVGRP);
#checked order, names
create table cru_proj_allowed_reviewer (cru_project_id integer not null, cru_user_id integer not null, primary key (cru_project_id, cru_user_id));
insert into cru_proj_allowed_reviewer (select PROJECT_ID, USER_ID from CRUPROJECT_ALWDREV);
#checked order, names
create table cru_proj_default_grp (cru_project_id integer not null, cru_group_name varchar(255));
insert into cru_proj_default_grp (select PROJECT_ID, GROUP_NAME from CRUPROJECT_DEFREVGRP);
#checked order, names
create table cru_proj_default_reviewer (cru_project_id integer not null, cru_user_id integer not null, primary key (cru_project_id, cru_user_id));
insert into cru_proj_default_reviewer (select PROJECT_ID, USER_ID from CRUPROJECT_DEFREV);
#checked order, names
create table cru_project (cru_project_id integer not null, cru_name varchar(80), cru_proj_key varchar(80), cru_default_repository_name varchar(255), cru_allow_reviewers_to_join bit, cru_store_revisions bit, cru_permission_scheme integer, cru_default_moderator integer, primary key (cru_project_id));
insert into cru_project (select PROJECT_ID, name, key, defaultRepositoryName, allowReviewersToJoin, storeRevisions, permissionScheme, defaultModerator from CRUPROJECT);
#checked order, names
create table cru_ps_all_user (cru_ps integer not null, cru_action_name varchar(80) not null, primary key (cru_ps, cru_action_name));
insert into cru_ps_all_user (select ps, actionName from PS_ALL_USER);
#checked order, names
create table cru_ps_anon (cru_ps integer not null, cru_action_name varchar(80) not null, primary key (cru_ps, cru_action_name));
insert into cru_ps_anon (select ps, actionName from PS_ANON);
#checked order, names
create table cru_ps_group (cru_ps integer not null, cru_pid varchar(255) not null, cru_action_name varchar(80) not null, primary key (cru_ps, cru_pid, cru_action_name));
insert into cru_ps_group (select ps, pid, actionName from PS_GROUP);
#checked order, names
create table cru_ps_review_role (cru_ps integer not null, cru_pid varchar(255) not null, cru_action_name varchar(80) not null, primary key (cru_ps, cru_pid, cru_action_name));
insert into cru_ps_review_role (select ps, pid, actionName from PS_REVIEW_ROLE);
#checked order, names
create table cru_ps_user (cru_ps integer not null, cru_pid varchar(255) not null, cru_action_name varchar(80) not null, primary key (cru_ps, cru_pid, cru_action_name));
insert into cru_ps_user (select ps, pid, actionName from PS_USER);
#checked order, names
create table cru_recipient (cru_recipient_id integer not null, cru_email integer, cru_rss integer, cru_ui_ack bit, cru_notification_id integer not null, cru_user integer, primary key (cru_recipient_id));
insert into cru_recipient (select RECIPIENT_ID, email, rss, uiACK, NOTIFICATION_ID, user from RECIPIENT);
#checked order, names
create table cru_reply (cru_comment_id integer not null, cru_reply_id integer not null, primary key (cru_comment_id, cru_reply_id));
insert into cru_reply (select COMMENT_ID, REPLY_ID from REPLY);
#checked order, names
create table cru_review (cru_review_id integer not null, cru_name varchar(255), cru_default_source varchar(80), cru_state varchar(80), cru_description longvarchar, cru_summary longvarchar, cru_allow_reviewer_to_join bit, cru_create_date timestamp, cru_metrics_version integer, cru_all_reviewers_complete bit, cru_parent_review integer, cru_creator integer, cru_project integer, primary key (cru_review_id));
insert into cru_review (select REVIEW_ID, name, defaultSource, state, description, summary, allowReviewerToJoin, CREATE_DATE, metricsVersion, allReviewersComplete, parentReview, creator, project from REVIEW);
#checked order, names
create table cru_review_comment (cru_review_id integer not null, cru_comment_id integer not null, primary key (cru_review_id, cru_comment_id));
insert into cru_review_comment (select REVIEW_ID, COMMENT_ID from REVIEW_COMMENT);
#checked order, names
create table cru_review_field (cru_review_id integer not null, cru_field_id integer not null, cru_field_order integer not null, primary key (cru_review_id, cru_field_order));
insert into cru_review_field (select REVIEW_ID, FIELD_ID, FIELD_ORDER from REVIEW_FIELD);
#checked order, names
create table cru_review_participant (cru_participant_id integer not null, cru_review_id integer not null, cru_user integer, cru_author bit, cru_moderator bit, cru_reviewer bit, cru_all_complete bit, cru_last_read timestamp, primary key (cru_participant_id), unique (cru_review_id, cru_user));
insert into cru_review_participant (select PARTICIPANT_ID, REVIEW_ID, user, author, moderator, reviewer, allComplete, LAST_READ from REVIEW_PARTICIPANT);
#checked order, names

#no existing table data to insert
create table cru_stored_path (cru_path_id integer not null, cru_path varchar(1000), primary key (cru_path_id), unique (cru_path));
create sequence stored_path_id_seq;
create table temp_table (cru_path varchar(1000), primary key (cru_path));
insert into temp_table (select distinct path from REVISION);
insert into cru_stored_path (select NEXT VALUE FOR stored_path_id_seq, cru_path from temp_table);
drop table temp_table;
drop sequence stored_path_id_seq;

create table cru_revision (cru_revision_id integer not null, cru_create_date timestamp, cru_commit_date timestamp, cru_author_name varchar(255), cru_deletion bit, cru_file_type varchar(255), cru_source_name varchar(255), cru_path integer, cru_revision varchar(255), cru_revision_display_name varchar(255), cru_upload_item integer, primary key (cru_revision_id), unique (cru_source_name, cru_path, cru_revision));
insert into cru_revision (select rev.REVISION_ID, rev.CREATE_DATE, rev.commitDate, rev.authorName, rev.deletion, rev.fileType, rev.sourceName, csp.cru_path_id, rev.revision, rev.revisionDisplayName, rev.uploadItem from REVISION rev, cru_stored_path csp where csp.cru_path = rev.path);
#checked order, names
create table cru_revision_comment (cru_rc_id integer not null, cru_create_date timestamp, cru_line_range varchar(255), cru_frx_id integer not null, cru_revision integer, cru_comment integer, primary key (cru_rc_id));
insert into cru_revision_comment (select RC_ID, CREATE_DATE, lineRange, FRX_ID, revision, comment from REVISION_COMMENT);
#checked order, names
create table cru_revpermaid (cru_proj_key varchar(80) not null, cru_number integer not null, cru_review_id integer, primary key (cru_proj_key, cru_number));
insert into cru_revpermaid (select key, number, REVIEW_ID from REVPERMAID);
#checked order, names
create table cru_state_change (cru_id integer not null, cru_time_stamp timestamp, cru_superseded timestamp, cru_review_id integer, cru_new_state varchar(80), primary key (cru_id));
insert into cru_state_change (select ID, TIME_STAMP, SUPERSEDED, reviewId, newState from STATE_CHANGE);

#checked order, names
create table cru_upload_item (cru_upload_id integer not null, cru_create_date timestamp, cru_user integer, cru_description varchar(1000), cru_charset varchar(80), cru_original_name varchar(1000), cru_original_content_type varchar(80), primary key (cru_upload_id));
insert into cru_upload_item (select UPLOAD_ID, CREATE_DATE, user, description, charset, originalName, originalContentType from UPLOAD);
#checked order, names
create table cru_user (cru_user_id integer not null, cru_userName varchar(255) not null, cru_dont_send__me_my_notes bit, cru_state_change_email_note integer, cru_comment_email_note integer, cru_reply_email_note integer, cru_general_email_note integer, cru_complete_email_note integer, primary key (cru_user_id), unique (cru_userName));
insert into cru_user (select USER_ID, userName, dontSendMeMyNotifications, stateChangeEmailNotification, commentEmailNotification, replyEmailNotification, generalEmailNotification, completeEmailNotification from USER);
#checked order, names
create table cru_version (cru_version_id integer not null, cru_version integer, primary key (cru_version_id));
insert into cru_version (select VERSION_ID, VERSION from CRUVERSION);

#drop existing tables

alter table COMMENT drop constraint FK63717A3FE71841CE;
alter table COMMENT drop constraint FK63717A3F1811CB9D;
alter table COMMENT drop constraint FK63717A3F252D1475;
alter table COMMENT_FIELD drop constraint FKADAF9ADAA18837F5;
alter table COMMENT_FIELD drop constraint FKADAF9ADA999D94C6;
alter table COMPLETED_FRX drop constraint FKC51038F8BBB0C6CE;
alter table COMPLETED_FRX drop constraint FKC51038F8D91F70A1;
alter table CRUPROJECT drop constraint FK343E6739DDC2572;
alter table CRUPROJECT drop constraint FK343E6733C0C9A9C;
alter table CRUPROJECT_ALWDREV drop constraint FKA85AE77F1811CB9D;
alter table CRUPROJECT_ALWDREV drop constraint FKA85AE77FA384A286;
alter table CRUPROJECT_ALWDREVGRP drop constraint FKAAA288E6A384A286;
alter table CRUPROJECT_DEFREV drop constraint FK6D3B6DCA1811CB9D;
alter table CRUPROJECT_DEFREV drop constraint FK6D3B6DCAA384A286;
alter table CRUPROJECT_DEFREVGRP drop constraint FK76CE5ABBA384A286;
alter table FEINDEX_MSG drop constraint FK45E4075FE42B18C;
alter table FR_DETAIL drop constraint FKEA43C324F8701D39;
alter table FR_EXTRA drop constraint FKFF633EBDE71841CE;
alter table FR_EXTRA drop constraint FKFF633EBD99758175;
alter table FR_EXTRA drop constraint FKFF633EBD547F95A3;
alter table INVITEES drop constraint FK54488D77E71841CE;
alter table NOTIFICATION drop constraint FKAD9970EBBE1FB2F1;
alter table NOTIFICATION drop constraint FKAD9970EB92041DC4;
alter table PATCH drop constraint FK48628286408C046;
alter table PATCH drop constraint FK486282892041DC4;
alter table PATCH_REVISION drop constraint FK7BE05E1257FBCB26;
alter table PATCH_REVISION drop constraint FK7BE05E121710F81D;
alter table PS_ALL_USER drop constraint FK5C45A285CF03846B;
alter table PS_ANON drop constraint FK1AEE3388CF03846B;
alter table PS_GROUP drop constraint FK432E9D23CF03846B;
alter table PS_REVIEW_ROLE drop constraint FK97DB18C1CF03846B;
alter table PS_USER drop constraint FK1AF75C87CF03846B;
alter table RECIPIENT drop constraint FKD6F981F9210DC959;
alter table RECIPIENT drop constraint FKD6F981F9FAA6A011;
alter table REPLY drop constraint FK4A41ACA999D94C6;
alter table REPLY drop constraint FK4A41ACA4A6A205B;
alter table REVIEW drop constraint FK8FE1EB585E255DBA;
alter table REVIEW drop constraint FK8FE1EB58680499E;
alter table REVIEW drop constraint FK8FE1EB583D2C7EEE;
alter table REVIEW_COMMENT drop constraint FKD84E3458E71841CE;
alter table REVIEW_COMMENT drop constraint FKD84E3458999D94C6;
alter table REVIEW_FIELD drop constraint FK90C31533E71841CE;
alter table REVIEW_FIELD drop constraint FK90C31533A18837F5;
alter table REVIEW_PARTICIPANT drop constraint FK936188AC210DC959;
alter table REVIEW_PARTICIPANT drop constraint FK936188ACE71841CE;
alter table REVISION drop constraint FK1F1AA7DB6408C046;
alter table REVISION_COMMENT drop constraint FKD00FBDDBE8E4C7F9;
alter table REVISION_COMMENT drop constraint FKD00FBDDB9CAB902A;
alter table REVISION_COMMENT drop constraint FKD00FBDDBD91F70A1;
alter table REVPERMAID drop constraint FK1DF5A649E71841CE;
alter table UPLOAD drop constraint FK95970201210DC959;
alter table cru_comment_read_status drop constraint FKC36175021811CB9D;
alter table cru_comment_read_status drop constraint FKC3617502999D94C6;

drop index idx_comment_defectApproved if exists;
drop index idx_comment_deleted if exists;
drop index idx_comment_user if exists;
drop index idx_comment_draft if exists;
drop index idx_comment_defectRaised if exists;
drop index proj_name_idx if exists;
drop index proj_key_idx if exists;
drop index idx_femsg_filerevision if exists;
drop index idx_femsg_review if exists;
drop index idx_field_scope if exists;
drop index idx_field_name if exists;
drop index idx_frx_fr if exists;
drop index idx_frx_fromfr if exists;
drop index idx_frx_review if exists;
drop index notifiaction if exists;
drop index notification if exists;
drop index notification if exists;
drop index patch_review_idx if exists;
drop index patch_ui_idx if exists;
drop index ps_name_idx if exists;
drop index recipient_email_idx if exists;
drop index recipient_rss_idx if exists;
drop index recipient_uiack_idx if exists;
drop index fr_name_idx if exists;
drop index fr_rev_idx if exists;
drop index fr_author_idx if exists;
drop index fr_path_idx if exists;
drop index fr_source_idx if exists;
drop index idx_rc_frx if exists;
drop index idx_rc_comment if exists;
drop index idx_rc_revision if exists;
drop index scl_review_idx if exists;
drop index scl_timestamp_idx if exists;
drop index scl_superseded_idx if exists;
drop index upload_user_idx if exists;
drop index idx_user_name if exists;
drop index cru_idx_star_name if exists;
drop index cru_idx_star_type if exists;
drop index cru_idx_comment_read_status_user if exists;
drop index cru_idx_comment_read_status_comment if exists;
drop index cru_idx_committer_mapping_user_name if exists;

drop table COMMENT if exists;
drop table COMMENT_FIELD if exists;
drop table COMPLETED_FRX if exists;
drop table CRUPROJECT if exists;
drop table CRUPROJECT_ALWDREV if exists;
drop table CRUPROJECT_ALWDREVGRP if exists;
drop table CRUPROJECT_DEFREV if exists;
drop table CRUPROJECT_DEFREVGRP if exists;
drop table CRUVERSION if exists;
drop table FEINDEX_MSG if exists;
drop table FIELD if exists;
drop table FR_DETAIL if exists;
drop table FR_EXTRA if exists;
drop table INVITEES if exists;
drop table LOGITEM if exists;
drop table METRIC_DEFINITION if exists;
drop table NOTIFICATION if exists;
drop table PATCH if exists;
drop table PATCH_REVISION if exists;
drop table PERM_SCHEME if exists;
drop table PS_ALL_USER if exists;
drop table PS_ANON if exists;
drop table PS_GROUP if exists;
drop table PS_REVIEW_ROLE if exists;
drop table PS_USER if exists;
drop table RECIPIENT if exists;
drop table REPLY if exists;
drop table REVIEW if exists;
drop table REVIEW_COMMENT if exists;
drop table REVIEW_FIELD if exists;
drop table REVIEW_PARTICIPANT if exists;
drop table REVISION if exists;
drop table REVISION_COMMENT if exists;
drop table REVPERMAID if exists;
drop table STATE_CHANGE if exists;
drop table UPLOAD if exists;
drop table USER if exists;

#add new constraints and indexes
create index cru_idx_star_type on cru_base_star_model (cru_item_type);
create index idx_comment_defectApproved on cru_comment (cru_defect_approved);
create index idx_comment_deleted on cru_comment (cru_deleted);
create index idx_comment_user on cru_comment (cru_user_id);
create index idx_comment_draft on cru_comment (cru_draft);
create index idx_comment_defectRaised on cru_comment (cru_defect_raised);
alter table cru_comment add constraint FKE5A1D10644A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_comment add constraint FKE5A1D106C50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_comment add constraint FKE5A1D10674DF349C foreign key (cru_reply_to_comment_id) references cru_comment;
alter table cru_comment_field add constraint FK44917881EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_comment_field add constraint FK449178819408AA2E foreign key (cru_field_id) references cru_field;
create index cru_idx_comment_read_status_user on cru_comment_read_status (USER_ID);
create index cru_idx_comment_read_status_comment on cru_comment_read_status (COMMENT_ID);
alter table cru_comment_read_status add constraint FKC36175021811CB9D foreign key (USER_ID) references cru_user;
alter table cru_comment_read_status add constraint FKC3617502999D94C6 foreign key (COMMENT_ID) references cru_comment;
create index cru_idx_committer_mapping_user_name on cru_committer_user_mapping (user_name);
alter table cru_completed_frx add constraint FK927E9E9F1BD6EA47 foreign key (cru_participant_id) references cru_review_participant;
alter table cru_completed_frx add constraint FK927E9E9F73591D1A foreign key (cru_frx_id) references cru_frx;
create index idx_femsg_filerevision on cru_feindex_msg (cru_fr_id);
create index idx_femsg_review on cru_feindex_msg (cru_review_id);
alter table cru_feindex_msg add constraint FKB56857DC665511F3 foreign key (cru_fr_id) references cru_revision;
create index idx_field_scope on cru_field (cru_field_scope);
create index idx_field_name on cru_field (cru_name);
alter table cru_fr_detail add constraint FK4F2200B487D2F44 foreign key (cru_revision_id) references cru_revision;
create index idx_frx_fr on cru_frx (cru_file_revision);
create index idx_frx_fromfr on cru_frx (cru_from_revision);
create index idx_frx_review on cru_frx (cru_review_id);
alter table cru_frx add constraint FK3E2EDB5344A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_frx add constraint FK3E2EDB53D70B78C3 foreign key (cru_file_revision) references cru_revision;
alter table cru_frx add constraint FK3E2EDB537D43EA55 foreign key (cru_from_revision) references cru_revision;
alter table cru_invitees add constraint FK18230FB044A616B5 foreign key (cru_review_id) references cru_review;
create index notifiaction_review_idx on cru_notification (cru_review);
create index notification_ref2_idx on cru_notification (cru_ref2);
create index notification_ref1_idx on cru_notification (cru_ref1);
alter table cru_notification add constraint FK1F9536A42C3DCA3D foreign key (cru_review) references cru_review;
alter table cru_notification add constraint FK1F9536A4B0A0252A foreign key (cru_actioner) references cru_user;
create index patch_review_idx on cru_patch (cru_review);
create index patch_ui_idx on cru_patch (cru_uploadItem);
alter table cru_patch add constraint FK6E6A80AFB835883F foreign key (cru_uploadItem) references cru_upload_item;
alter table cru_patch add constraint FK6E6A80AF2C3DCA3D foreign key (cru_review) references cru_review;
alter table cru_patch_revision add constraint FKD573BD6B4A7C3D5F foreign key (cru_PATCH_ID) references cru_patch;
alter table cru_patch_revision add constraint FKD573BD6B487D2F44 foreign key (cru_revision_id) references cru_revision;
create index ps_name_idx on cru_perm_scheme (cru_name);
alter table cru_proj_allowed_grp add constraint FK893AB525F7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5C50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_proj_allowed_reviewer add constraint FK1E8211C5F7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_default_grp add constraint FK1502953EF7B16A7F foreign key (cru_project_id) references cru_project;
alter table cru_proj_default_reviewer add constraint FK3F4F594CC50DAE44 foreign key (cru_user_id) references cru_user;
alter table cru_proj_default_reviewer add constraint FK3F4F594CF7B16A7F foreign key (cru_project_id) references cru_project;
create index proj_name_idx on cru_project (cru_name);
create index proj_key_idx on cru_project (cru_proj_key);
alter table cru_project add constraint FK9A8C2DC0F2648A64 foreign key (cru_permission_scheme) references cru_perm_scheme;
alter table cru_project add constraint FK9A8C2DC0E2A633FC foreign key (cru_default_moderator) references cru_user;
alter table cru_ps_all_user add constraint FK830D758C7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_anon add constraint FK9B5B9A2F7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_group add constraint FKD06E0B7C7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_review_role add constraint FK8204BC3A7E705564 foreign key (cru_ps) references cru_perm_scheme;
alter table cru_ps_user add constraint FK9B64C32E7E705564 foreign key (cru_ps) references cru_perm_scheme;
create index recipient_email_idx on cru_recipient (cru_email);
create index recipient_rss_idx on cru_recipient (cru_rss);
create index recipient_uiack_idx on cru_recipient (cru_ui_ack);
alter table cru_recipient add constraint FK8E6F4700A88A4012 foreign key (cru_user) references cru_user;
alter table cru_recipient add constraint FK8E6F47009F44EBB8 foreign key (cru_notification_id) references cru_notification;
alter table cru_reply add constraint FK6E887351EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_reply add constraint FK6E8873513CEA9294 foreign key (cru_reply_id) references cru_comment;
alter table cru_review add constraint FK6288A3D17492E860 foreign key (cru_parent_review) references cru_review;
alter table cru_review add constraint FK6288A3D1B37C2C45 foreign key (cru_project) references cru_project;
alter table cru_review add constraint FK6288A3D1B214061 foreign key (cru_creator) references cru_user;
alter table cru_review_comment add constraint FKBE49D7F1EDCA5CBF foreign key (cru_comment_id) references cru_comment;
alter table cru_review_comment add constraint FKBE49D7F144A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_review_field add constraint FKCC23C70C9408AA2E foreign key (cru_field_id) references cru_field;
alter table cru_review_field add constraint FKCC23C70C44A616B5 foreign key (cru_review_id) references cru_review;
alter table cru_review_participant add constraint FK54EBFC5A88A4012 foreign key (cru_user) references cru_user;
alter table cru_review_participant add constraint FK54EBFC544A616B5 foreign key (cru_review_id) references cru_review;
create index fr_name_idx on cru_revision (cru_revision_display_name);
create index fr_rev_idx on cru_revision (cru_revision);
create index fr_author_idx on cru_revision (cru_author_name);
create index fr_source_idx on cru_revision (cru_source_name);
alter table cru_revision add constraint FKE2F52A1434AAD25A foreign key (cru_path) references cru_stored_path;
alter table cru_revision add constraint FKE2F52A14E35E156A foreign key (cru_upload_item) references cru_upload_item;
create index idx_rc_frx on cru_revision_comment (cru_frx_id);
create index idx_rc_comment on cru_revision_comment (cru_comment);
create index idx_rc_revision on cru_revision_comment (cru_revision);
alter table cru_revision_comment add constraint FKB2B96B34DB653A32 foreign key (cru_revision) references cru_revision;
alter table cru_revision_comment add constraint FKB2B96B3473591D1A foreign key (cru_frx_id) references cru_frx;
alter table cru_revision_comment add constraint FKB2B96B3449A772D1 foreign key (cru_comment) references cru_comment;
alter table cru_revpermaid add constraint FK5538824244A616B5 foreign key (cru_review_id) references cru_review;
create index scl_review_idx on cru_state_change (cru_review_id);
create index scl_timestamp_idx on cru_state_change (cru_time_stamp);
create index scl_superseded_idx on cru_state_change (cru_superseded);
create index upload_user_idx on cru_upload_item (cru_user);
alter table cru_upload_item add constraint FK70E1F5B8A88A4012 foreign key (cru_user) references cru_user;
create index idx_user_name on cru_user (cru_userName);

UPDATE cru_version SET cru_version = 31 WHERE cru_version_id = 1;
