#convert back to memory tables from cached
alter table COMMENT drop constraint FK63717A3F1811CB9D;
alter table COMMENT drop constraint FK63717A3FE71841CE;
alter table COMMENT drop constraint FK63717A3F252D1475;
alter table COMMENT_FIELD drop constraint FKADAF9ADA999D94C6;
alter table COMMENT_FIELD drop constraint FKADAF9ADAA18837F5;
alter table COMPLETED_FRX drop constraint FKC51038F8BBB0C6CE;
alter table COMPLETED_FRX drop constraint FKC51038F8D91F70A1;
alter table CRUPROJECT drop constraint FK343E6733C0C9A9C;
alter table CRUPROJECT drop constraint FK343E6739DDC2572;
alter table CRUPROJECT_ALWDREV drop constraint FKA85AE77FA384A286;
alter table CRUPROJECT_ALWDREV drop constraint FKA85AE77F1811CB9D;
alter table CRUPROJECT_ALWDREVGRP drop constraint FKAAA288E6A384A286;
alter table CRUPROJECT_DEFREV drop constraint FK6D3B6DCAA384A286;
alter table CRUPROJECT_DEFREV drop constraint FK6D3B6DCA1811CB9D;
alter table CRUPROJECT_DEFREVGRP drop constraint FK76CE5ABBA384A286;
alter table FEINDEX_MSG drop constraint FK45E4075FE42B18C;
alter table FR_DETAIL drop constraint FKEA43C324F8701D39;
alter table FR_EXTRA drop constraint FKFF633EBD547F95A3;
alter table FR_EXTRA drop constraint FKFF633EBD99758175;
alter table FR_EXTRA drop constraint FKFF633EBDE71841CE;
alter table INVITEES drop constraint FK54488D77E71841CE;
alter table NOTIFICATION drop constraint FKAD9970EBBE1FB2F1;
alter table NOTIFICATION drop constraint FKAD9970EB92041DC4;
alter table PATCH drop constraint FK486282892041DC4;
alter table PATCH drop constraint FK48628286408C046;
alter table PATCH_REVISION drop constraint FK7BE05E121710F81D;
alter table PATCH_REVISION drop constraint FK7BE05E1257FBCB26;
alter table PS_ALL_USER drop constraint FK5C45A285CF03846B;
alter table PS_ANON drop constraint FK1AEE3388CF03846B;
alter table PS_GROUP drop constraint FK432E9D23CF03846B;
alter table PS_REVIEW_ROLE drop constraint FK97DB18C1CF03846B;
alter table PS_USER drop constraint FK1AF75C87CF03846B;
alter table RECIPIENT drop constraint FKD6F981F9FAA6A011;
alter table RECIPIENT drop constraint FKD6F981F9210DC959;
alter table REPLY drop constraint FK4A41ACA4A6A205B;
alter table REPLY drop constraint FK4A41ACA999D94C6;
alter table REVIEW drop constraint FK8FE1EB58680499E;
alter table REVIEW drop constraint FK8FE1EB585E255DBA;
alter table REVIEW drop constraint FK8FE1EB583D2C7EEE;
alter table REVIEW_COMMENT drop constraint FKD84E3458E71841CE;
alter table REVIEW_COMMENT drop constraint FKD84E3458999D94C6;
alter table REVIEW_FIELD drop constraint FK90C31533E71841CE;
alter table REVIEW_FIELD drop constraint FK90C31533A18837F5;
alter table REVIEW_PARTICIPANT drop constraint FK936188ACE71841CE;
alter table REVIEW_PARTICIPANT drop constraint FK936188AC210DC959;
alter table REVISION drop constraint FK1F1AA7DB6408C046;
alter table REVISION_COMMENT drop constraint FKD00FBDDBE8E4C7F9;
alter table REVISION_COMMENT drop constraint FKD00FBDDBD91F70A1;
alter table REVISION_COMMENT drop constraint FKD00FBDDB9CAB902A;
alter table REVPERMAID drop constraint FK1DF5A649E71841CE;
alter table UPLOAD drop constraint FK95970201210DC959;

drop index idx_comment_defectApproved if exists;
drop index idx_comment_deleted if exists;
drop index idx_comment_user if exists;
drop index idx_comment_draft if exists;
drop index idx_comment_defectRaised if exists;
drop index proj_name_idx if exists;
drop index proj_key_idx if exists;
drop index idx_femsg_filerevision if exists;
drop index idx_femsg_review if exists;
drop index idx_field_scope if exists;
drop index idx_field_name if exists;
drop index idx_frx_fr if exists;
drop index idx_frx_fromfr if exists;
drop index idx_frx_review if exists;
drop index notifiaction if exists;
drop index notification if exists;
drop index notification if exists;
drop index patch_review_idx if exists;
drop index patch_ui_idx if exists;
drop index ps_name_idx if exists;
drop index recipient_email_idx if exists;
drop index recipient_rss_idx if exists;
drop index recipient_uiack_idx if exists;
drop index fr_name_idx if exists;
drop index fr_rev_idx if exists;
drop index fr_author_idx if exists;
drop index fr_path_idx if exists;
drop index fr_source_idx if exists;
drop index idx_rc_frx if exists;
drop index idx_rc_comment if exists;
drop index idx_rc_revision if exists;
drop index scl_review_idx if exists;
drop index scl_timestamp_idx if exists;
drop index scl_superseded_idx if exists;
drop index upload_user_idx if exists;
drop index idx_user_name if exists;

alter table COMMENT rename to T_COMMENT;
alter table COMMENT_FIELD rename to T_COMMENT_FIELD;
alter table COMPLETED_FRX rename to T_COMPLETED_FRX;
alter table CRUPROJECT rename to T_CRUPROJECT;
alter table CRUPROJECT_ALWDREV rename to T_CRUPROJECT_ALWDREV;
alter table CRUPROJECT_ALWDREVGRP rename to T_CRUPROJECT_ALWDREVGRP;
alter table CRUPROJECT_DEFREV rename to T_CRUPROJECT_DEFREV;
alter table CRUPROJECT_DEFREVGRP rename to T_CRUPROJECT_DEFREVGRP;
alter table CRUVERSION rename to T_CRUVERSION;
alter table FEINDEX_MSG rename to T_FEINDEX_MSG;
alter table FIELD rename to T_FIELD;
alter table FR_DETAIL rename to T_FR_DETAIL;
alter table FR_EXTRA rename to T_FR_EXTRA;
alter table INVITEES rename to T_INVITEES;
alter table LOGITEM rename to T_LOGITEM;
alter table METRIC_DEFINITION rename to T_METRIC_DEFINITION;
alter table NOTIFICATION rename to T_NOTIFICATION;
alter table PATCH rename to T_PATCH;
alter table PATCH_REVISION rename to T_PATCH_REVISION;
alter table PERM_SCHEME rename to T_PERM_SCHEME;
alter table PS_ALL_USER rename to T_PS_ALL_USER;
alter table PS_ANON rename to T_PS_ANON;
alter table PS_GROUP rename to T_PS_GROUP;
alter table PS_REVIEW_ROLE rename to T_PS_REVIEW_ROLE;
alter table PS_USER rename to T_PS_USER;
alter table RECIPIENT rename to T_RECIPIENT;
alter table REPLY rename to T_REPLY;
alter table REVIEW rename to T_REVIEW;
alter table REVIEW_COMMENT rename to T_REVIEW_COMMENT;
alter table REVIEW_FIELD rename to T_REVIEW_FIELD;
alter table REVIEW_PARTICIPANT rename to T_REVIEW_PARTICIPANT;
alter table REVISION rename to T_REVISION;
alter table REVISION_COMMENT rename to T_REVISION_COMMENT;
alter table REVPERMAID rename to T_REVPERMAID;
alter table STATE_CHANGE rename to T_STATE_CHANGE;
alter table UPLOAD rename to T_UPLOAD;
alter table USER rename to T_USER;

create memory table COMMENT (COMMENT_ID integer not null, CREATE_DATE timestamp, message longvarchar not null, draft bit not null, deleted bit not null, defectRaised bit not null, defectApproved bit not null, USER_ID integer, REVIEW_ID integer not null, REPLY_TO_COMMENT_ID integer, primary key (COMMENT_ID));
create memory table COMMENT_FIELD (COMMENT_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (COMMENT_ID, FIELD_ORDER));
create memory table COMPLETED_FRX (PARTICIPANT_ID integer not null, FRX_ID integer not null, primary key (PARTICIPANT_ID, FRX_ID));
create memory table CRUPROJECT (PROJECT_ID integer not null, name varchar(255), key varchar(255), defaultRepositoryName varchar(255), allowReviewersToJoin bit, storeRevisions bit, permissionScheme integer, defaultModerator integer, primary key (PROJECT_ID));
create memory table CRUPROJECT_ALWDREV (PROJECT_ID integer not null, USER_ID integer not null, primary key (PROJECT_ID, USER_ID));
create memory table CRUPROJECT_ALWDREVGRP (PROJECT_ID integer not null, GROUP_NAME varchar(255));
create memory table CRUPROJECT_DEFREV (PROJECT_ID integer not null, USER_ID integer not null, primary key (PROJECT_ID, USER_ID));
create memory table CRUPROJECT_DEFREVGRP (PROJECT_ID integer not null, GROUP_NAME varchar(255));
create memory table CRUVERSION (VERSION_ID integer not null, VERSION integer, primary key (VERSION_ID));
create memory table FEINDEX_MSG (ID integer not null, FR_ID integer, REVIEW_ID integer not null, primary key (ID));
create memory table FIELD (FIELD_ID integer not null, configVersion integer, fieldScope varchar(255), name varchar(255), stringVal varchar(255), intVal integer, booleanVal bit, DATE timestamp, primary key (FIELD_ID));
create memory table FR_DETAIL (id integer not null, value varchar(255), name varchar(255) not null, primary key (id, name));
create memory table FR_EXTRA (FRX_ID integer not null, WHEN_ADDED timestamp, reviewed integer, furtherAction integer, reviewScope integer, fileRevision integer, REVIEW_ID integer not null, fromRevision integer, FRX_ORDER integer, primary key (FRX_ID), unique (fileRevision, REVIEW_ID));
create memory table INVITEES (REVIEW_ID integer not null, ADDRESS varchar(255));
create memory table LOGITEM (LOGITEM_ID integer not null, CREATE_DATE timestamp, item longvarchar, primary key (LOGITEM_ID));
create memory table METRIC_DEFINITION (METRIC_ID integer not null, xml longvarchar, primary key (METRIC_ID));
create memory table NOTIFICATION (NOTIFICATION_ID integer not null, NOTE_TYPE varchar(255) not null, CREATE_DATE timestamp, actioner integer, note varchar(255), review integer, ref1 integer, ref2 integer, primary key (NOTIFICATION_ID));
create memory table PATCH (PATCH_ID integer not null, review integer, uploadItem integer, primary key (PATCH_ID));
create memory table PATCH_REVISION (PATCH_ID integer not null, REVISION_ID integer not null, REVISION_ORDER integer not null, primary key (PATCH_ID, REVISION_ORDER));
create memory table PERM_SCHEME (PS_ID integer not null, name varchar(255), primary key (PS_ID), unique (name));
create memory table PS_ALL_USER (ps integer not null, actionName varchar(255) not null, primary key (ps, actionName));
create memory table PS_ANON (ps integer not null, actionName varchar(255) not null, primary key (ps, actionName));
create memory table PS_GROUP (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create memory table PS_REVIEW_ROLE (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create memory table PS_USER (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create memory table RECIPIENT (RECIPIENT_ID integer not null, email integer, rss integer, uiACK bit, NOTIFICATION_ID integer not null, user integer, primary key (RECIPIENT_ID));
create memory table REPLY (COMMENT_ID integer not null, REPLY_ID integer not null, primary key (COMMENT_ID, REPLY_ID));
create memory table REVIEW (REVIEW_ID integer not null, name varchar(255), defaultSource varchar(255), state varchar(255), description varchar(255), summary varchar(255), allowReviewerToJoin bit, CREATE_DATE timestamp, metricsVersion integer, allReviewersComplete bit, parentReview integer, creator integer, project integer, primary key (REVIEW_ID));
create memory table REVIEW_COMMENT (REVIEW_ID integer not null, COMMENT_ID integer not null, primary key (REVIEW_ID, COMMENT_ID));
create memory table REVIEW_FIELD (REVIEW_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (REVIEW_ID, FIELD_ORDER));
create memory table REVIEW_PARTICIPANT (PARTICIPANT_ID integer not null, REVIEW_ID integer not null, user integer, author bit, moderator bit, reviewer bit, allComplete bit, LAST_READ timestamp, primary key (PARTICIPANT_ID), unique (REVIEW_ID, user));
create memory table REVISION (REVISION_ID integer not null, CREATE_DATE timestamp, commitDate timestamp, authorName varchar(255), deletion bit, fileType varchar(255), sourceName varchar(255), path varchar(255), revision varchar(255), revisionDisplayName varchar(255), uploadItem integer, primary key (REVISION_ID), unique (sourceName, path, revision));
create memory table REVISION_COMMENT (RC_ID integer not null, CREATE_DATE timestamp, lineRange varchar(255), FRX_ID integer not null, revision integer, comment integer, primary key (RC_ID));
create memory table REVPERMAID (key varchar(255) not null, number integer not null, REVIEW_ID integer, primary key (key, number));
create memory table STATE_CHANGE (ID integer not null, TIME_STAMP timestamp, SUPERSEDED timestamp, reviewId integer, newState varchar(255), primary key (ID));
create memory table UPLOAD (UPLOAD_ID integer not null, CREATE_DATE timestamp, user integer, description varchar(255), charset varchar(255), originalName varchar(255), originalContentType varchar(255), primary key (UPLOAD_ID));
create memory table USER (USER_ID integer not null, userName varchar(255), dontSendMeMyNotifications bit, stateChangeEmailNotification integer, commentEmailNotification integer, replyEmailNotification integer, generalEmailNotification integer, completeEmailNotification integer, primary key (USER_ID), unique (userName));

insert into COMMENT (select COMMENT_ID, CREATE_DATE, message, draft, deleted, defectRaised, defectApproved, USER_ID, REVIEW_ID, REPLY_TO_COMMENT_ID from T_COMMENT);
insert into COMMENT_FIELD (select COMMENT_ID, FIELD_ID, FIELD_ORDER from T_COMMENT_FIELD);
insert into COMPLETED_FRX (select PARTICIPANT_ID, FRX_ID from T_COMPLETED_FRX);
insert into CRUPROJECT (select PROJECT_ID, name, key, defaultRepositoryName, allowReviewersToJoin, storeRevisions, permissionScheme, defaultModerator from T_CRUPROJECT);
insert into CRUPROJECT_ALWDREV (select PROJECT_ID, USER_ID from T_CRUPROJECT_ALWDREV);
insert into CRUPROJECT_ALWDREVGRP (select PROJECT_ID, GROUP_NAME from T_CRUPROJECT_ALWDREVGRP);
insert into CRUPROJECT_DEFREV (select PROJECT_ID, USER_ID from T_CRUPROJECT_DEFREV);
insert into CRUPROJECT_DEFREVGRP (select PROJECT_ID, GROUP_NAME from T_CRUPROJECT_DEFREVGRP);
insert into CRUVERSION (select VERSION_ID, VERSION from T_CRUVERSION);
insert into FEINDEX_MSG (select ID, FR_ID, REVIEW_ID from T_FEINDEX_MSG);
insert into FIELD (select FIELD_ID, configVersion, fieldScope, name, stringVal, intVal, booleanVal, DATE from T_FIELD);
insert into FR_DETAIL (select id, value, name from T_FR_DETAIL);
insert into FR_EXTRA (select FRX_ID, WHEN_ADDED, reviewed, furtherAction, reviewScope, fileRevision, REVIEW_ID, fromRevision, FRX_ORDER from T_FR_EXTRA);
insert into INVITEES (select REVIEW_ID, ADDRESS from T_INVITEES);
insert into LOGITEM (select LOGITEM_ID, CREATE_DATE, item from T_LOGITEM);
insert into METRIC_DEFINITION (select METRIC_ID, xml from T_METRIC_DEFINITION);
insert into NOTIFICATION (select NOTIFICATION_ID, NOTE_TYPE, CREATE_DATE, actioner, note, review, ref1, ref2 from T_NOTIFICATION);
insert into PATCH (select PATCH_ID, review, uploadItem from T_PATCH);
insert into PATCH_REVISION (select PATCH_ID, REVISION_ID, REVISION_ORDER from T_PATCH_REVISION);
insert into PERM_SCHEME (select PS_ID, name from T_PERM_SCHEME);
insert into PS_ALL_USER (select ps, actionName from T_PS_ALL_USER);
insert into PS_ANON (select ps, actionName from T_PS_ANON);
insert into PS_GROUP (select ps, pid, actionName from T_PS_GROUP);
insert into PS_REVIEW_ROLE (select ps, pid, actionName from T_PS_REVIEW_ROLE);
insert into PS_USER (select ps, pid, actionName from T_PS_USER);
insert into RECIPIENT (select RECIPIENT_ID, email, rss, uiACK, NOTIFICATION_ID, user from T_RECIPIENT);
insert into REPLY (select COMMENT_ID, REPLY_ID from T_REPLY);
insert into REVIEW (select REVIEW_ID, name, defaultSource, state, description, summary, allowReviewerToJoin, CREATE_DATE, metricsVersion, allReviewersComplete, parentReview, creator, project from T_REVIEW);
insert into REVIEW_COMMENT (select REVIEW_ID, COMMENT_ID from T_REVIEW_COMMENT);
insert into REVIEW_FIELD (select REVIEW_ID, FIELD_ID, FIELD_ORDER from T_REVIEW_FIELD);
insert into REVIEW_PARTICIPANT (select PARTICIPANT_ID, REVIEW_ID, user, author, moderator, reviewer, allComplete, LAST_READ from T_REVIEW_PARTICIPANT);
insert into REVISION (select REVISION_ID, CREATE_DATE, commitDate, authorName, deletion, fileType, sourceName, path, revision, revisionDisplayName, uploadItem from T_REVISION);
insert into REVISION_COMMENT (select RC_ID, CREATE_DATE, lineRange, FRX_ID, revision, comment from T_REVISION_COMMENT);
insert into REVPERMAID (select key, number, REVIEW_ID from T_REVPERMAID);
insert into STATE_CHANGE (select ID, TIME_STAMP, SUPERSEDED, reviewId, newState from T_STATE_CHANGE);
insert into UPLOAD (select UPLOAD_ID, CREATE_DATE, user, description, charset, originalName, originalContentType from T_UPLOAD);
insert into USER (select USER_ID, userName, dontSendMeMyNotifications, stateChangeEmailNotification, commentEmailNotification, replyEmailNotification, generalEmailNotification, completeEmailNotification from T_USER);

drop table T_COMMENT if exists;
drop table T_COMMENT_FIELD if exists;
drop table T_COMPLETED_FRX if exists;
drop table T_CRUPROJECT if exists;
drop table T_CRUPROJECT_ALWDREV if exists;
drop table T_CRUPROJECT_ALWDREVGRP if exists;
drop table T_CRUPROJECT_DEFREV if exists;
drop table T_CRUPROJECT_DEFREVGRP if exists;
drop table T_CRUVERSION if exists;
drop table T_FEINDEX_MSG if exists;
drop table T_FIELD if exists;
drop table T_FR_DETAIL if exists;
drop table T_FR_EXTRA if exists;
drop table T_INVITEES if exists;
drop table T_LOGITEM if exists;
drop table T_METRIC_DEFINITION if exists;
drop table T_NOTIFICATION if exists;
drop table T_PATCH if exists;
drop table T_PATCH_REVISION if exists;
drop table T_PERM_SCHEME if exists;
drop table T_PS_ALL_USER if exists;
drop table T_PS_ANON if exists;
drop table T_PS_GROUP if exists;
drop table T_PS_REVIEW_ROLE if exists;
drop table T_PS_USER if exists;
drop table T_RECIPIENT if exists;
drop table T_REPLY if exists;
drop table T_REVIEW if exists;
drop table T_REVIEW_COMMENT if exists;
drop table T_REVIEW_FIELD if exists;
drop table T_REVIEW_PARTICIPANT if exists;
drop table T_REVISION if exists;
drop table T_REVISION_COMMENT if exists;
drop table T_REVPERMAID if exists;
drop table T_STATE_CHANGE if exists;
drop table T_UPLOAD if exists;
drop table T_USER if exists;

create index idx_comment_defectApproved on COMMENT (defectApproved);
create index idx_comment_deleted on COMMENT (deleted);
create index idx_comment_user on COMMENT (USER_ID);
create index idx_comment_draft on COMMENT (draft);
create index idx_comment_defectRaised on COMMENT (defectRaised);
alter table COMMENT add constraint FK63717A3F1811CB9D foreign key (USER_ID) references USER;
alter table COMMENT add constraint FK63717A3FE71841CE foreign key (REVIEW_ID) references REVIEW;
alter table COMMENT add constraint FK63717A3F252D1475 foreign key (REPLY_TO_COMMENT_ID) references COMMENT;
alter table COMMENT_FIELD add constraint FKADAF9ADA999D94C6 foreign key (COMMENT_ID) references COMMENT;
alter table COMMENT_FIELD add constraint FKADAF9ADAA18837F5 foreign key (FIELD_ID) references FIELD;
alter table COMPLETED_FRX add constraint FKC51038F8BBB0C6CE foreign key (PARTICIPANT_ID) references REVIEW_PARTICIPANT;
alter table COMPLETED_FRX add constraint FKC51038F8D91F70A1 foreign key (FRX_ID) references FR_EXTRA;
create index proj_name_idx on CRUPROJECT (name);
create index proj_key_idx on CRUPROJECT (key);
alter table CRUPROJECT add constraint FK343E6733C0C9A9C foreign key (permissionScheme) references PERM_SCHEME;
alter table CRUPROJECT add constraint FK343E6739DDC2572 foreign key (defaultModerator) references USER;
alter table CRUPROJECT_ALWDREV add constraint FKA85AE77FA384A286 foreign key (PROJECT_ID) references CRUPROJECT;
alter table CRUPROJECT_ALWDREV add constraint FKA85AE77F1811CB9D foreign key (USER_ID) references USER;
alter table CRUPROJECT_ALWDREVGRP add constraint FKAAA288E6A384A286 foreign key (PROJECT_ID) references CRUPROJECT;
alter table CRUPROJECT_DEFREV add constraint FK6D3B6DCAA384A286 foreign key (PROJECT_ID) references CRUPROJECT;
alter table CRUPROJECT_DEFREV add constraint FK6D3B6DCA1811CB9D foreign key (USER_ID) references USER;
alter table CRUPROJECT_DEFREVGRP add constraint FK76CE5ABBA384A286 foreign key (PROJECT_ID) references CRUPROJECT;
create index idx_femsg_filerevision on FEINDEX_MSG (FR_ID);
create index idx_femsg_review on FEINDEX_MSG (REVIEW_ID);
alter table FEINDEX_MSG add constraint FK45E4075FE42B18C foreign key (FR_ID) references REVISION;
create index idx_field_scope on FIELD (fieldScope);
create index idx_field_name on FIELD (name);
alter table FR_DETAIL add constraint FKEA43C324F8701D39 foreign key (id) references REVISION;
create index idx_frx_fr on FR_EXTRA (fileRevision);
create index idx_frx_fromfr on FR_EXTRA (fromRevision);
create index idx_frx_review on FR_EXTRA (REVIEW_ID);
alter table FR_EXTRA add constraint FKFF633EBD547F95A3 foreign key (fromRevision) references REVISION;
alter table FR_EXTRA add constraint FKFF633EBD99758175 foreign key (fileRevision) references REVISION;
alter table FR_EXTRA add constraint FKFF633EBDE71841CE foreign key (REVIEW_ID) references REVIEW;
alter table INVITEES add constraint FK54488D77E71841CE foreign key (REVIEW_ID) references REVIEW;
create index notifiaction_review_idx on NOTIFICATION (review);
create index notification_ref2_idx on NOTIFICATION (ref2);
create index notification_ref1_idx on NOTIFICATION (ref1);
alter table NOTIFICATION add constraint FKAD9970EBBE1FB2F1 foreign key (actioner) references USER;
alter table NOTIFICATION add constraint FKAD9970EB92041DC4 foreign key (review) references REVIEW;
create index patch_review_idx on PATCH (review);
create index patch_ui_idx on PATCH (uploadItem);
alter table PATCH add constraint FK486282892041DC4 foreign key (review) references REVIEW;
alter table PATCH add constraint FK48628286408C046 foreign key (uploadItem) references UPLOAD;
alter table PATCH_REVISION add constraint FK7BE05E121710F81D foreign key (REVISION_ID) references REVISION;
alter table PATCH_REVISION add constraint FK7BE05E1257FBCB26 foreign key (PATCH_ID) references PATCH;
create index ps_name_idx on PERM_SCHEME (name);
alter table PS_ALL_USER add constraint FK5C45A285CF03846B foreign key (ps) references PERM_SCHEME;
alter table PS_ANON add constraint FK1AEE3388CF03846B foreign key (ps) references PERM_SCHEME;
alter table PS_GROUP add constraint FK432E9D23CF03846B foreign key (ps) references PERM_SCHEME;
alter table PS_REVIEW_ROLE add constraint FK97DB18C1CF03846B foreign key (ps) references PERM_SCHEME;
alter table PS_USER add constraint FK1AF75C87CF03846B foreign key (ps) references PERM_SCHEME;
create index recipient_email_idx on RECIPIENT (email);
create index recipient_rss_idx on RECIPIENT (rss);
create index recipient_uiack_idx on RECIPIENT (uiACK);
alter table RECIPIENT add constraint FKD6F981F9FAA6A011 foreign key (NOTIFICATION_ID) references NOTIFICATION;
alter table RECIPIENT add constraint FKD6F981F9210DC959 foreign key (user) references USER;
alter table REPLY add constraint FK4A41ACA4A6A205B foreign key (REPLY_ID) references COMMENT;
alter table REPLY add constraint FK4A41ACA999D94C6 foreign key (COMMENT_ID) references COMMENT;
alter table REVIEW add constraint FK8FE1EB58680499E foreign key (project) references CRUPROJECT;
alter table REVIEW add constraint FK8FE1EB585E255DBA foreign key (creator) references USER;
alter table REVIEW add constraint FK8FE1EB583D2C7EEE foreign key (parentReview) references REVIEW;
alter table REVIEW_COMMENT add constraint FKD84E3458E71841CE foreign key (REVIEW_ID) references REVIEW;
alter table REVIEW_COMMENT add constraint FKD84E3458999D94C6 foreign key (COMMENT_ID) references COMMENT;
alter table REVIEW_FIELD add constraint FK90C31533E71841CE foreign key (REVIEW_ID) references REVIEW;
alter table REVIEW_FIELD add constraint FK90C31533A18837F5 foreign key (FIELD_ID) references FIELD;
alter table REVIEW_PARTICIPANT add constraint FK936188ACE71841CE foreign key (REVIEW_ID) references REVIEW;
alter table REVIEW_PARTICIPANT add constraint FK936188AC210DC959 foreign key (user) references USER;
create index fr_name_idx on REVISION (revisionDisplayName);
create index fr_rev_idx on REVISION (revision);
create index fr_author_idx on REVISION (authorName);
create index fr_path_idx on REVISION (path);
create index fr_source_idx on REVISION (sourceName);
alter table REVISION add constraint FK1F1AA7DB6408C046 foreign key (uploadItem) references UPLOAD;
create index idx_rc_frx on REVISION_COMMENT (FRX_ID);
create index idx_rc_comment on REVISION_COMMENT (comment);
create index idx_rc_revision on REVISION_COMMENT (revision);
alter table REVISION_COMMENT add constraint FKD00FBDDBE8E4C7F9 foreign key (revision) references REVISION;
alter table REVISION_COMMENT add constraint FKD00FBDDBD91F70A1 foreign key (FRX_ID) references FR_EXTRA;
alter table REVISION_COMMENT add constraint FKD00FBDDB9CAB902A foreign key (comment) references COMMENT;
alter table REVPERMAID add constraint FK1DF5A649E71841CE foreign key (REVIEW_ID) references REVIEW;
create index scl_review_idx on STATE_CHANGE (reviewId);
create index scl_timestamp_idx on STATE_CHANGE (TIME_STAMP);
create index scl_superseded_idx on STATE_CHANGE (SUPERSEDED);
create index upload_user_idx on UPLOAD (user);
alter table UPLOAD add constraint FK95970201210DC959 foreign key (user) references USER;
create index idx_user_name on USER (userName);

UPDATE CRUVERSION SET version = 29 WHERE version_id = 1;
