#changed constraints
alter table FEINDEX_MSG drop constraint FK45E4075EE7606F9;
alter table FR_EXTRA drop constraint FKFF633EBD44B2EB10;
alter table FR_EXTRA drop constraint FKFF633EBD89A8D6E2;
alter table PATCH_REVISION drop constraint FK7BE05E127444D8A;
alter table REVISION_COMMENT drop constraint FKD00FBDDBD9181D66;

#drop index of removed field
drop index fr_result_idx if exists;

drop index fr_name_idx if exists;
drop index fr_rev_idx if exists;

create table FR_DETAIL (id integer not null, value varchar(255), name varchar(255) not null, primary key (id, name));

alter table REVISION drop column reviewResult;
alter table REVISION alter column revIdent rename to revision;
alter table REVISION alter column revisionName rename to revisionDisplayName;

#these new fields will be lazily updated by Content Manager as the CrucibleRevision is updated.
alter table REVISION add column commitDate timestamp;
alter table REVISION add column authorName varchar(255);
alter table REVISION add column deletion bit;
alter table REVISION add column fileType varchar(255); 

#add changed/new constraints
alter table FEINDEX_MSG add constraint FK45E4075FE42B18C foreign key (FR_ID) references REVISION;
alter table FR_DETAIL add constraint FKEA43C324F8701D39 foreign key (id) references REVISION;
alter table FR_EXTRA add constraint FKFF633EBD547F95A3 foreign key (fromRevision) references REVISION;
alter table FR_EXTRA add constraint FKFF633EBD99758175 foreign key (fileRevision) references REVISION;
alter table PATCH_REVISION add constraint FK7BE05E121710F81D foreign key (REVISION_ID) references REVISION;
alter table REVISION_COMMENT add constraint FKD00FBDDBE8E4C7F9 foreign key (revision) references REVISION;

#add new index
create index fr_author_idx on REVISION (authorName);
create index fr_name_idx on REVISION (revisionDisplayName);
create index fr_rev_idx on REVISION (revision);

UPDATE REVISION SET sourceName=SUBSTRING(sourceName FROM 4) WHERE sourceName like 'FE:%';
UPDATE CRUVERSION SET version = 25 WHERE version_id = 1;
