create table PATCH (PATCH_ID integer not null, review integer, uploadItem integer, primary key (PATCH_ID));
create table PATCH_REVISION (PATCH_ID integer not null, REVISION_ID integer not null, REVISION_ORDER integer not null, primary key (PATCH_ID, REVISION_ORDER));
create table UPLOAD (UPLOAD_ID integer not null, CREATE_DATE timestamp, user integer, description varchar(255), originalName varchar(255), originalContentType varchar(255), primary key (UPLOAD_ID));
create index patch_review_idx on PATCH (review);
create index patch_ui_idx on PATCH (uploadItem);

drop index fr_revs_idx;
alter table REVISION alter COLUMN revision rename to revIdent;
alter table REVISION add COLUMN revisionName varchar(255);
update REVISION set revisionName = revIdent;
update REVISION set sourceName = 'FE:' + sourceName;
create index fr_name_idx on REVISION (revisionName);
create index fr_rev_idx on REVISION (revIdent);

alter table PATCH add constraint FK486282892041DC4 foreign key (review) references REVIEW;
alter table PATCH add constraint FK48628286408C046 foreign key (uploadItem) references UPLOAD;
alter table PATCH_REVISION add constraint FK7BE05E127444D8A foreign key (REVISION_ID) references REVISION;
alter table PATCH_REVISION add constraint FK7BE05E1257FBCB26 foreign key (PATCH_ID) references PATCH;
create index upload_user_idx on UPLOAD (user);
alter table UPLOAD add constraint FK95970201210DC959 foreign key (user) references USER;

UPDATE CRUVERSION SET version = 17 WHERE version_id = 1;
