create table ACTION_ITEM (ACTION_ITEM_ID integer not null, CREATE_DATE timestamp, title varchar(255), summary varchar(255), REVIEW_ID integer not null, primary key (ACTION_ITEM_ID));
create table ACTIVE_REVIEWER (REVIEW_ID integer not null, USER_ID integer not null, primary key (REVIEW_ID, USER_ID));
create table AI_COMMENT (ACTION_ITEM_ID integer not null, COMMENT_ID integer not null, primary key (ACTION_ITEM_ID, COMMENT_ID));
create table AI_FIELD (ACTION_ITEM_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (ACTION_ITEM_ID, FIELD_ORDER));
create table AI_RELATED_COMMENT (ACTION_ITEM_ID integer not null, COMMENT_ID integer not null, primary key (ACTION_ITEM_ID, COMMENT_ID));
create table COMMENT (COMMENT_ID integer not null, CREATE_DATE timestamp, message longvarchar, draft bit, deleted bit, USER_ID integer, primary key (COMMENT_ID));
create table COMMENT_FIELD (COMMENT_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (COMMENT_ID, FIELD_ORDER));
create table COMPLETED_REVIEWER (REVIEW_ID integer not null, USER_ID integer not null, primary key (REVIEW_ID, USER_ID));
create table CRUVERSION (VERSION_ID integer not null, VERSION integer, primary key (VERSION_ID));
create table FIELD (FIELD_ID integer not null, configVersion integer, fieldScope varchar(255), name varchar(255), stringVal varchar(255), intVal integer, booleanVal bit, DATE timestamp, primary key (FIELD_ID));
create table FR_EXTRA (FRX_ID integer not null, WHEN_ADDED timestamp, reviewed integer, furtherAction integer, reviewScope integer, fileRevision integer, REVIEW_ID integer not null, fromRevision integer, FRX_ORDER integer, primary key (FRX_ID), unique (fileRevision, REVIEW_ID));
create table LOGITEM (LOGITEM_ID integer not null, CREATE_DATE timestamp, item longvarchar, primary key (LOGITEM_ID));
create table METRIC_DEFINITION (METRIC_ID integer not null, xml longvarchar, primary key (METRIC_ID));
create table NOTIFICATION (NOTIFICATION_ID integer not null, NOTE_TYPE varchar(255) not null, CREATE_DATE timestamp, actioner integer, note varchar(255), review integer, ref1 integer, ref2 integer, primary key (NOTIFICATION_ID));
create table RECIPIENT (RECIPIENT_ID integer not null, email integer, uiACK bit, NOTIFICATION_ID integer not null, user integer, primary key (RECIPIENT_ID));
create table REPLY (COMMENT_ID integer not null, REPLY_ID integer not null, primary key (COMMENT_ID, REPLY_ID));
create table REVIEW (REVIEW_ID integer not null, name varchar(255), repoName varchar(255), state varchar(255), description varchar(255), summary varchar(255), CREATE_DATE timestamp, metricsVersion integer, author integer, moderator integer, creator integer, primary key (REVIEW_ID));
create table REVIEW_COMMENT (REVIEW_ID integer not null, COMMENT_ID integer not null, primary key (REVIEW_ID, COMMENT_ID));
create table REVIEW_FIELD (REVIEW_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (REVIEW_ID, FIELD_ORDER));
create table REVISION (REVISION_ID integer not null, CREATE_DATE timestamp, source varchar(255), path varchar(255), revision varchar(255), reviewResult varchar(255), primary key (REVISION_ID), unique (source, path, revision));
create table REVISION_COMMENT (RC_ID integer not null, CREATE_DATE timestamp, lineRange varchar(255), FRX_ID integer not null, revision integer, comment integer, primary key (RC_ID));
create table STATE_CHANGE (ID integer not null, TIME_STAMP timestamp, reviewId integer, newState varchar(255), primary key (ID));
create table USER (USER_ID integer not null, userName varchar(255), dontSendMeMyNotifications bit, stateChangeEmailNotification integer, commentEmailNotification integer, replyEmailNotification integer, generalEmailNotification integer, completeEmailNotification integer, primary key (USER_ID));
insert into CRUVERSION values (1,7);
